/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.cache;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.cache.AbstractCache;
import net.pterodactylus.util.cache.CacheException;
import net.pterodactylus.util.cache.CacheItem;
import net.pterodactylus.util.cache.DefaultCacheItem;
import net.pterodactylus.util.cache.ValueRetriever;
import net.pterodactylus.util.cache.WritableCache;
import net.pterodactylus.util.logging.Logging;

public class MemoryCache<K, V>
extends AbstractCache<K, V>
implements WritableCache<K, V> {
    private static Logger logger = Logging.getLogger(MemoryCache.class.getName());
    private final Map<K, CacheItem<V>> cachedValues;
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();

    public MemoryCache(ValueRetriever<K, V> valueRetriever) {
        this(valueRetriever, 50);
    }

    public MemoryCache(ValueRetriever<K, V> valueRetriever, final int cacheSize) {
        this(valueRetriever, new LinkedHashMap<K, CacheItem<V>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, CacheItem<V>> eldest) {
                if (super.size() > cacheSize) {
                    eldest.getValue().remove();
                    return true;
                }
                return false;
            }
        });
    }

    public MemoryCache(ValueRetriever<K, V> valueRetriever, Map<K, CacheItem<V>> storage) {
        super(valueRetriever);
        this.cachedValues = storage;
    }

    public static void setLogger(Logger logger) {
        MemoryCache.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.cacheLock.writeLock().lock();
        try {
            this.cachedValues.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this.cacheLock.readLock().lock();
        try {
            boolean bl = this.cachedValues.containsKey(key);
            return bl;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws CacheException {
        this.cacheLock.readLock().lock();
        try {
            if (this.cachedValues.containsKey(key)) {
                logger.log(Level.FINE, "Value for Key \u201c%1$s\u201d is in cache.", key);
                V v = this.cachedValues.get(key).getItem();
                return v;
            }
            logger.log(Level.INFO, "Retrieving Value for Key \u201c%1$s\u201d...", key);
            CacheItem value = this.retrieveValue(key);
            if (value != null) {
                this.cacheLock.readLock().unlock();
                this.cacheLock.writeLock().lock();
                try {
                    this.cachedValues.put(key, value);
                }
                finally {
                    this.cacheLock.readLock().lock();
                    this.cacheLock.writeLock().unlock();
                }
            }
            logger.log(Level.FINE, "Retrieved Value for Key \u201c%1$s\u201d.", key);
            V v = value != null ? (V)value.getItem() : null;
            return v;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        this.cacheLock.writeLock().lock();
        try {
            this.cachedValues.remove(key);
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.cacheLock.writeLock().lock();
        try {
            this.cachedValues.put(key, new DefaultCacheItem<V>(value));
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.cacheLock.readLock().lock();
        try {
            int n = this.cachedValues.size();
            return n;
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
    }
}

