/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.cache;

import net.pterodactylus.util.cache.CacheException;
import net.pterodactylus.util.cache.ItemValueRetriever;
import net.pterodactylus.util.cache.MemoryItemCache;
import net.pterodactylus.util.thread.Ticker;

public class TimedMemoryItemCache<T>
extends MemoryItemCache<T> {
    private final long maxCacheTime;
    private Object tickerObject;

    public TimedMemoryItemCache(ItemValueRetriever<T> itemValueRetriever, long maxCacheTime) {
        super(itemValueRetriever);
        this.maxCacheTime = maxCacheTime;
    }

    @Override
    public T get() throws CacheException {
        Object value = super.get();
        if (value != null) {
            if (this.tickerObject == null) {
                this.tickerObject = Ticker.getInstance().registerEvent(System.currentTimeMillis() + this.maxCacheTime, new Runnable(){

                    @Override
                    public void run() {
                        TimedMemoryItemCache.this.clear();
                    }
                }, "Memory Item Cache Cleaner");
            } else {
                Ticker.getInstance().changeExecutionTime(this.tickerObject, System.currentTimeMillis() + this.maxCacheTime);
            }
        }
        return value;
    }
}

