/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.cmdline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pterodactylus.util.cmdline.CommandLineException;
import net.pterodactylus.util.cmdline.Option;
import net.pterodactylus.util.validation.Validation;

public class CommandLine {
    private final Map<Character, Option> shortNameOptions = new HashMap<Character, Option>();
    private final Map<String, Option> longNameOptions = new HashMap<String, Option>();
    private List<String> arguments = new ArrayList<String>();

    public CommandLine(String[] commandLineArguments, Collection<Option> options) throws CommandLineException {
        this(commandLineArguments, options.toArray(new Option[options.size()]));
    }

    public CommandLine(String[] commandLineArguments, Option ... options) throws CommandLineException {
        Validation.begin().isNotNull("commandLineArguments", commandLineArguments).check();
        for (Option option : options) {
            if (option.getShortName() != '\u0000') {
                this.shortNameOptions.put(Character.valueOf(option.getShortName()), option);
            }
            if (option.getLongName() == null) continue;
            this.longNameOptions.put(option.getLongName(), option);
        }
        int argumentCount = commandLineArguments.length;
        boolean argumentsOnly = false;
        ArrayList<Option> optionsNeedingParameters = new ArrayList<Option>();
        for (int argumentIndex = 0; argumentIndex < argumentCount; ++argumentIndex) {
            String argument = commandLineArguments[argumentIndex];
            if (!optionsNeedingParameters.isEmpty()) {
                Option option = (Option)optionsNeedingParameters.remove(0);
                option.setValue(argument);
                continue;
            }
            if (argumentsOnly) {
                this.arguments.add(argument);
                continue;
            }
            if ("--".equals(argument)) {
                argumentsOnly = true;
                continue;
            }
            if (argument.startsWith("--")) {
                String longName = argument.substring(2);
                Option option = this.longNameOptions.get(longName);
                if (option == null) {
                    throw new CommandLineException("unknown long name: " + longName);
                }
                if (option.needsParameter()) {
                    int equals = longName.indexOf(61);
                    if (equals == -1) {
                        optionsNeedingParameters.add(option);
                    } else {
                        option.setValue(longName.substring(equals + 1));
                    }
                }
                option.incrementCounter();
                continue;
            }
            if (argument.startsWith("-")) {
                String optionChars = argument.substring(1);
                for (char optionChar : optionChars.toCharArray()) {
                    Option option = this.shortNameOptions.get(Character.valueOf(optionChar));
                    if (option == null) {
                        throw new CommandLineException("unknown short name: " + optionChar);
                    }
                    if (option.needsParameter()) {
                        optionsNeedingParameters.add(option);
                    }
                    option.incrementCounter();
                }
                continue;
            }
            this.arguments.add(argument);
        }
        if (!optionsNeedingParameters.isEmpty()) {
            throw new CommandLineException("missing value for option " + optionsNeedingParameters.get(0));
        }
    }

    public Option getOption(char name) {
        return this.shortNameOptions.get(Character.valueOf(name));
    }

    public Option getOption(String name) {
        Validation.begin().isNotNull("name", name).check();
        if (name.length() > 1 && this.longNameOptions.containsKey(name)) {
            return this.longNameOptions.get(name);
        }
        if (name.length() == 1 && this.shortNameOptions.containsKey(Character.valueOf(name.charAt(0)))) {
            return this.shortNameOptions.get(Character.valueOf(name.charAt(0)));
        }
        return null;
    }

    public String[] getArguments() {
        return this.arguments.toArray(new String[this.arguments.size()]);
    }
}

