/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import net.pterodactylus.util.config.AbstractValue;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.ExtendedConfigurationBackend;
import net.pterodactylus.util.config.ValueFormatException;

public class IntegerValue
extends AbstractValue<Integer> {
    public IntegerValue(Configuration configuration, String attribute) {
        super(configuration, attribute);
    }

    @Override
    public Integer getValue() throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getIntegerValue(this.attribute);
        }
        String value = null;
        try {
            value = this.configuration.configurationBackend.getValue(this.attribute);
            int integerValue = Integer.valueOf(value);
            return integerValue;
        }
        catch (NumberFormatException nfe1) {
            throw new ValueFormatException("could not parse attribute \"" + value + "\".", nfe1);
        }
    }

    @Override
    public Integer getValue(Integer defaultValue) {
        String value = null;
        try {
            if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
                return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getIntegerValue(this.attribute);
            }
            value = this.configuration.configurationBackend.getValue(this.attribute);
            int integerValue = Integer.valueOf(value);
            return integerValue;
        }
        catch (NumberFormatException nfe1) {
            return defaultValue;
        }
        catch (ConfigurationException ce1) {
            return defaultValue;
        }
    }

    @Override
    public void setValue(Integer newValue) throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            ((ExtendedConfigurationBackend)this.configuration.configurationBackend).setIntegerValue(this.attribute, newValue);
        }
        this.configuration.configurationBackend.putValue(this.attribute, newValue != null ? String.valueOf(newValue) : null);
    }
}

