/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.config;

import net.pterodactylus.util.config.AbstractValue;
import net.pterodactylus.util.config.Configuration;
import net.pterodactylus.util.config.ConfigurationException;
import net.pterodactylus.util.config.ExtendedConfigurationBackend;
import net.pterodactylus.util.config.ValueFormatException;

public class LongValue
extends AbstractValue<Long> {
    public LongValue(Configuration configuration, String attribute) {
        super(configuration, attribute);
    }

    @Override
    public Long getValue() throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getLongValue(this.attribute);
        }
        String value = null;
        try {
            value = this.configuration.configurationBackend.getValue(this.attribute);
            long longValue = Long.valueOf(value);
            return longValue;
        }
        catch (NumberFormatException nfe1) {
            throw new ValueFormatException("could not parse attribute \"" + value + "\".", nfe1);
        }
    }

    @Override
    public Long getValue(Long defaultValue) {
        String value = null;
        try {
            if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
                return ((ExtendedConfigurationBackend)this.configuration.configurationBackend).getLongValue(this.attribute);
            }
            value = this.configuration.configurationBackend.getValue(this.attribute);
            long longValue = Long.valueOf(value);
            return longValue;
        }
        catch (NumberFormatException nfe1) {
            return defaultValue;
        }
        catch (ConfigurationException ce1) {
            return defaultValue;
        }
    }

    @Override
    public void setValue(Long newValue) throws ConfigurationException {
        if (this.configuration.configurationBackend instanceof ExtendedConfigurationBackend) {
            ((ExtendedConfigurationBackend)this.configuration.configurationBackend).setLongValue(this.attribute, newValue);
        }
        this.configuration.configurationBackend.putValue(this.attribute, newValue != null ? String.valueOf(newValue) : null);
    }
}

