/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.io;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    private final OutputStream[] outputStreams;

    public TeeOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = outputStreams;
    }

    @Override
    public void write(int data) throws IOException {
        for (OutputStream outputStream : this.outputStreams) {
            outputStream.write(data);
        }
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        for (OutputStream outputStream : this.outputStreams) {
            outputStream.write(buffer);
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        for (OutputStream outputStream : this.outputStreams) {
            outputStream.write(buffer, offset, length);
        }
    }

    @Override
    public void flush() throws IOException {
        IOException occuredException = null;
        for (OutputStream outputStream : this.outputStreams) {
            try {
                outputStream.flush();
            }
            catch (IOException ioe1) {
                if (occuredException != null) continue;
                occuredException = ioe1;
            }
        }
        if (occuredException != null) {
            throw occuredException;
        }
    }

    @Override
    public void close() throws IOException {
        IOException occuredException = null;
        for (OutputStream outputStream : this.outputStreams) {
            try {
                outputStream.flush();
            }
            catch (IOException ioe1) {
                if (occuredException != null) continue;
                occuredException = ioe1;
            }
        }
        if (occuredException != null) {
            throw occuredException;
        }
    }
}

