/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.number;

public class Bits {
    public static boolean decodeBit(int value, int bitIndex) {
        return Bits.decodeBits(value, bitIndex, 1) == 1;
    }

    public static int decodeBits(int value, int bitIndex, int numberOfBits) {
        return value >> bitIndex & (1 << numberOfBits) - 1;
    }

    public static int encodeBits(int oldValue, int bitIndex, int numberOfBits, int newValue) {
        return oldValue & ~((1 << numberOfBits) - 1 << bitIndex) | (newValue & (1 << numberOfBits) - 1) << bitIndex;
    }

    public static int rotateLeft(int value, int distance) {
        return value << (distance & 0x1F) | value >>> (32 - distance & 0x1F);
    }

    public static long rotateLeft(long value, int distance) {
        return value << distance | value >>> 64 - (distance & 0x3F);
    }

    public static int rotateRight(int value, int distance) {
        return value >>> (distance & 0x1F) | value << (32 - distance & 0x1F);
    }

    public static long rotateRight(long value, int distance) {
        return value >>> distance | value << 64 - (distance & 0x1F);
    }
}

