/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.number;

public class Digits {
    public static String format(long value, int digits) {
        String formattedValue = String.valueOf(value);
        while (formattedValue.length() < digits) {
            formattedValue = "0" + formattedValue;
        }
        return formattedValue;
    }

    public static String formatFractions(double value, int fractionDigits, boolean round) {
        double factor = Math.pow(10.0, fractionDigits);
        int tempValue = (int)(value * factor + (round ? 0.5 : 0.0));
        String formattedValue = String.valueOf((double)tempValue / factor);
        if (formattedValue.indexOf(46) == -1) {
            formattedValue = formattedValue + ".";
            for (int count = 0; count < fractionDigits; ++count) {
                formattedValue = formattedValue + "0";
            }
        } else {
            while (formattedValue.length() - formattedValue.indexOf(46) <= fractionDigits) {
                formattedValue = formattedValue + "0";
            }
        }
        return formattedValue;
    }

    public static long parseLong(String digits) throws NumberFormatException {
        return Long.parseLong(digits);
    }

    public static long parseLong(String digits, long defaultValue) {
        try {
            return Long.parseLong(digits);
        }
        catch (NumberFormatException nfe1) {
            return defaultValue;
        }
    }

    public static int parseInt(String digits) throws NumberFormatException {
        return Integer.parseInt(digits);
    }

    public static int parseInt(String digits, int defaultValue) {
        try {
            return Integer.parseInt(digits);
        }
        catch (NumberFormatException nfe1) {
            return defaultValue;
        }
    }

    public static double round(double number, double unit) {
        return (double)((long)(number / unit + 0.5)) * unit;
    }
}

