/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.swing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

public class SortedListModel<T extends Comparable<T>>
extends AbstractListModel
implements List<T> {
    private List<T> elements = new ArrayList<T>();

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.elements.get(index);
    }

    @Override
    public void add(int index, T element) {
        this.elements.add(index, element);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
    }

    @Override
    public boolean add(T o) {
        boolean result = this.elements.add(o);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = this.elements.addAll(c);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = this.elements.addAll(index, c);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return result;
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.fireContentsChanged(this, 0, this.size());
    }

    @Override
    public boolean contains(Object o) {
        return this.elements.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.elements.containsAll(c);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.elements).equals(o);
    }

    @Override
    public T get(int index) {
        return (T)((Comparable)this.elements.get(index));
    }

    @Override
    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    @Override
    public int indexOf(Object o) {
        return this.elements.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.elements.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.elements.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.elements.listIterator(index);
    }

    @Override
    public T remove(int index) {
        this.fireContentsChanged(this, 0, this.size());
        return (T)((Comparable)this.elements.remove(index));
    }

    @Override
    public boolean remove(Object o) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.fireContentsChanged(this, 0, this.size());
        return this.elements.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        Comparable result = (Comparable)this.elements.set(index, element);
        Collections.sort(this.elements);
        this.fireContentsChanged(this, 0, this.size());
        return (T)result;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.elements.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.elements.toArray(a);
    }
}

