/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.telnet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface Command {
    public String getName();

    public String getBriefDescription();

    public List<String> getDetailedDescription();

    public Reply execute(List<String> var1);

    public static class Reply {
        public static final int OK = 200;
        public static final int MULTIPLE_CHOICES = 300;
        public static final int BAD_REQUEST = 400;
        public static final int NOT_FOUND = 404;
        public static final int INTERNAL_SERVER_ERROR = 500;
        private final int status;
        private final List<String> lines = new ArrayList<String>();

        public Reply(int status) {
            this.status = status;
        }

        public Reply(int status, String line) {
            this(status, new String[]{line});
        }

        public Reply(int status, String ... lines) {
            this(status, Arrays.asList(lines));
        }

        public Reply(int status, List<String> lines) {
            this.status = status;
            this.lines.addAll(lines);
        }

        public Reply addLine(String line) {
            this.lines.add(line);
            return this;
        }

        public int getStatus() {
            return this.status;
        }

        public List<String> getLines() {
            return this.lines;
        }
    }
}

