/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.template;

import java.io.Writer;
import java.util.Map;
import net.pterodactylus.util.template.AbstractPart;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateException;

public class TemplatePart
extends AbstractPart {
    private final String templateName;
    private final Map<String, String> parameters;

    public TemplatePart(int line, int column, String templateName, Map<String, String> parameters) {
        super(line, column);
        this.templateName = templateName;
        this.parameters = parameters;
    }

    @Override
    public void render(TemplateContext templateContext, Writer writer) throws TemplateException {
        Template template = templateContext.getTemplate(this.templateName);
        if (template == null) {
            throw new TemplateException(this.getLine(), this.getColumn(), "Template \u201c" + this.templateName + "\u201d not found.");
        }
        TemplateContext includedContext = new TemplateContext(templateContext);
        for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
            if (parameter.getValue().startsWith("=")) {
                includedContext.set(parameter.getKey(), parameter.getValue().substring(1));
                continue;
            }
            includedContext.set(parameter.getKey(), templateContext.get(parameter.getValue()));
        }
        template.render(includedContext, writer);
    }
}

