/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.pterodactylus.util.collection.Pair;

public class RegularExpressionNumberFormat
extends NumberFormat {
    private final List<Pair<Pattern, String>> patterns = new ArrayList<Pair<Pattern, String>>();
    private final String defaultValue;

    public RegularExpressionNumberFormat(String expression) throws PatternSyntaxException {
        this(expression, '/', ';');
    }

    public RegularExpressionNumberFormat(String expression, char separator, char patternSeparator) throws PatternSyntaxException {
        String defaultValue = null;
        for (String pattern : expression.split(String.valueOf(patternSeparator))) {
            if (pattern.indexOf(separator) < 0) {
                defaultValue = pattern;
                break;
            }
            String regularExpression = pattern.substring(0, pattern.indexOf(separator));
            String value = pattern.substring(pattern.indexOf(separator) + 1);
            if (value.startsWith(String.valueOf(separator))) {
                defaultValue = value = value.substring(1);
            }
            this.patterns.add(new Pair<Pattern, String>(Pattern.compile(regularExpression), value));
        }
        this.defaultValue = defaultValue;
    }

    private StringBuffer format(String number, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        for (Pair<Pattern, String> pattern : this.patterns) {
            if (!pattern.getLeft().matcher(number).matches()) continue;
            toAppendTo.append(pattern.getRight());
            return toAppendTo;
        }
        if (this.defaultValue != null) {
            toAppendTo.append(this.defaultValue);
        }
        return toAppendTo;
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(String.valueOf(number), toAppendTo, pos);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.format(String.valueOf(number), toAppendTo, pos);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        return null;
    }
}

