/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.web;

import java.io.IOException;
import java.io.InputStream;
import net.pterodactylus.util.io.StreamCopier;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.Request;
import net.pterodactylus.util.web.Response;

public class StaticPage<REQ extends Request>
implements Page<REQ> {
    private final String pathPrefix;
    private final String resourcePathPrefix;
    private final String mimeType;

    public StaticPage(String pathPrefix, String resourcePathPrefix, String mimeType) {
        this.pathPrefix = pathPrefix;
        this.resourcePathPrefix = resourcePathPrefix;
        this.mimeType = mimeType;
    }

    @Override
    public String getPath() {
        return this.pathPrefix;
    }

    @Override
    public boolean isPrefixPage() {
        return true;
    }

    @Override
    public Response handleRequest(REQ request, Response response) throws IOException {
        String path = ((Request)request).getUri().getPath();
        int lastSlash = path.lastIndexOf(47);
        String filename = path.substring(lastSlash + 1);
        InputStream fileInputStream = this.getClass().getResourceAsStream(this.resourcePathPrefix + filename);
        if (fileInputStream == null) {
            return response.setStatusCode(404).setStatusText("Not found.");
        }
        StreamCopier.copy(fileInputStream, response.getContent());
        return response.setStatusCode(200).setStatusText("OK").setContentType(this.mimeType);
    }
}

