/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.web;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import net.pterodactylus.util.template.Template;
import net.pterodactylus.util.template.TemplateContext;
import net.pterodactylus.util.template.TemplateContextFactory;
import net.pterodactylus.util.template.TemplateException;
import net.pterodactylus.util.web.Page;
import net.pterodactylus.util.web.RedirectException;
import net.pterodactylus.util.web.RedirectResponse;
import net.pterodactylus.util.web.Request;
import net.pterodactylus.util.web.Response;

public class TemplatePage<REQ extends Request>
implements Page<REQ> {
    private static final Logger logger = Logging.getLogger(TemplatePage.class);
    private final String path;
    private final String contentType;
    private final TemplateContextFactory templateContextFactory;
    private final Template template;

    public TemplatePage(String path, String contentType, TemplateContextFactory templateContextFactory, Template template) {
        this.path = path;
        this.contentType = contentType;
        this.templateContextFactory = templateContextFactory;
        this.template = template;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public boolean isPrefixPage() {
        return false;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response handleRequest(REQ request, Response response) throws IOException {
        OutputStreamWriter responseWriter = null;
        try {
            responseWriter = new OutputStreamWriter(response.getContent(), "UTF-8");
            TemplateContext templateContext = this.templateContextFactory.createTemplateContext();
            templateContext.set("request", request);
            this.processTemplate(templateContext, request);
            this.template.render(templateContext, responseWriter);
        }
        catch (RedirectException re1) {
            RedirectResponse redirectResponse = new RedirectResponse(re1.getTarget());
            {
                catch (Throwable throwable) {
                    Closer.close(responseWriter);
                    throw throwable;
                }
            }
            Closer.close(responseWriter);
            return redirectResponse;
            catch (IOException ioe1) {
                logger.log(Level.WARNING, "Could not render template for path \u201c" + this.path + "\u201d!", ioe1);
                throw ioe1;
                catch (TemplateException te1) {
                    logger.log(Level.WARNING, "Could not render template for path \u201c" + this.path + "\u201d!", te1);
                    throw new IOException(te1);
                }
            }
        }
        Closer.close(responseWriter);
        return response.setStatusCode(200).setStatusText("OK").setContentType(this.contentType);
    }

    protected void processTemplate(TemplateContext templateContext, REQ request) throws RedirectException {
    }
}

