/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.pterodactylus.util.logging.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SimpleXML {
    private static final Logger logger = Logging.getLogger(SimpleXML.class.getName());
    private List<SimpleXML> children = new ArrayList<SimpleXML>();
    private String name = null;
    private String value = null;
    private Map<String, String> attributes = null;

    public SimpleXML() {
    }

    public SimpleXML(String name) {
        this(name, (String[])null, (String[])null);
    }

    public SimpleXML(String name, String attributeName, String attributeValue) {
        this(name, new String[]{attributeName}, new String[]{attributeValue});
    }

    public SimpleXML(String name, String[] attributeNames, String[] attributeValues) {
        this.name = name;
        this.attributes = new HashMap<String, String>();
        if (attributeNames != null && attributeValues != null && attributeNames.length == attributeValues.length) {
            int size = attributeNames.length;
            for (int index = 0; index < size; ++index) {
                this.attributes.put(attributeNames[index], attributeValues[index]);
            }
        }
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public String getAttribute(String attributeName) {
        return this.getAttribute(attributeName, null);
    }

    public String getAttribute(String attributeName, String defaultValue) {
        if (!this.attributes.containsKey(attributeName)) {
            return defaultValue;
        }
        return this.attributes.get(attributeName);
    }

    public void setAttribute(String attributeName, String attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }

    public String removeAttribute(String attributeName) {
        return this.attributes.remove(attributeName);
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    public boolean hasNodes() {
        return !this.children.isEmpty();
    }

    public boolean hasNode(String nodeName) {
        return this.getNode(nodeName) != null;
    }

    public SimpleXML getNode(String nodeName) {
        int count = this.children.size();
        for (int index = 0; index < count; ++index) {
            if (!this.children.get((int)index).name.equals(nodeName)) continue;
            return this.children.get(index);
        }
        return null;
    }

    public SimpleXML getNode(String[] nodeNames) {
        SimpleXML node = this;
        for (String nodeName : nodeNames) {
            node = node.getNode(nodeName);
        }
        return node;
    }

    public SimpleXML[] getNodes() {
        return this.getNodes(null);
    }

    public SimpleXML[] getNodes(String nodeName) {
        ArrayList<SimpleXML> resultList = new ArrayList<SimpleXML>();
        for (SimpleXML child : this.children) {
            if (nodeName != null && !child.name.equals(nodeName)) continue;
            resultList.add(child);
        }
        return resultList.toArray(new SimpleXML[resultList.size()]);
    }

    public SimpleXML append(String nodeName) {
        return this.append(new SimpleXML(nodeName));
    }

    public SimpleXML append(String nodeName, String nodeValue) {
        return this.append(nodeName).setValue(nodeValue);
    }

    public SimpleXML append(SimpleXML newChild) {
        this.children.add(newChild);
        return newChild;
    }

    public void remove(SimpleXML child) {
        this.children.remove(child);
    }

    public void remove(String childName) {
        SimpleXML child = this.getNode(childName);
        if (child != null) {
            this.remove(child);
        }
    }

    public void replace(String childName, String value) {
        this.remove(childName);
        this.append(childName, value);
    }

    public void replace(SimpleXML childNode) {
        this.remove(childNode.getName());
        this.append(childNode);
    }

    public void removeAll() {
        this.children.clear();
    }

    public SimpleXML setValue(String nodeValue) {
        this.value = nodeValue;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String childName) {
        return this.getNode(childName).getValue();
    }

    public String getValue(String childName, String defaultValue) {
        SimpleXML childNode = this.getNode(childName);
        if (childNode == null) {
            return defaultValue;
        }
        return childNode.getValue() == null ? defaultValue : childNode.getValue();
    }

    public Document getDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element rootElement = document.createElement(this.name);
            for (Map.Entry<String, String> attributeEntry : this.attributes.entrySet()) {
                rootElement.setAttribute(attributeEntry.getKey(), attributeEntry.getValue());
            }
            document.appendChild(rootElement);
            this.addChildren(rootElement);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    private void addChildren(Element rootElement) {
        for (SimpleXML child : this.children) {
            Element childElement = rootElement.getOwnerDocument().createElement(child.name);
            for (Map.Entry<String, String> attributeEntry : child.attributes.entrySet()) {
                childElement.setAttribute(attributeEntry.getKey(), attributeEntry.getValue());
            }
            rootElement.appendChild(childElement);
            if (child.value != null) {
                Text childText = rootElement.getOwnerDocument().createTextNode(child.value);
                childElement.appendChild(childText);
                continue;
            }
            child.addChildren(childElement);
        }
    }

    public static SimpleXML fromDocument(Document document) {
        SimpleXML xmlDocument = new SimpleXML(document.getFirstChild().getNodeName());
        NamedNodeMap attributes = document.getFirstChild().getAttributes();
        int attributeCount = attributes.getLength();
        for (int attributeIndex = 0; attributeIndex < attributeCount; ++attributeIndex) {
            Node attribute = attributes.item(attributeIndex);
            logger.log(Level.FINER, "adding attribute: " + attribute.getNodeName() + " = " + attribute.getNodeValue());
            xmlDocument.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
        }
        document.normalizeDocument();
        Node firstChild = null;
        NodeList children = document.getChildNodes();
        int count = children.getLength();
        for (int index = 0; index < count; ++index) {
            Node child = children.item(index);
            if (child.getNodeType() == 8 || child.getNodeType() == 7) continue;
            firstChild = child;
            break;
        }
        return SimpleXML.addDocumentChildren(xmlDocument, firstChild);
    }

    private static SimpleXML addDocumentChildren(SimpleXML xmlDocument, Node document) {
        NodeList childNodes = document.getChildNodes();
        int childCount = childNodes.getLength();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            Node attribute;
            int attributeIndex;
            int attributeCount;
            NamedNodeMap childNodeAttributes;
            SimpleXML newXML;
            Node childNode = childNodes.item(childIndex);
            if (childNode.getChildNodes().getLength() == 1 && childNode.getFirstChild().getNodeName().equals("#text")) {
                newXML = xmlDocument.append(childNode.getNodeName(), childNode.getFirstChild().getNodeValue());
                childNodeAttributes = childNode.getAttributes();
                attributeCount = childNodeAttributes.getLength();
                for (attributeIndex = 0; attributeIndex < attributeCount; ++attributeIndex) {
                    attribute = childNodeAttributes.item(attributeIndex);
                    logger.log(Level.FINER, "adding attribute: " + attribute.getNodeName() + " = " + attribute.getNodeValue());
                    newXML.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                }
                continue;
            }
            if (childNode.getNodeType() != 1 && childNode.getChildNodes().getLength() == 0) continue;
            newXML = xmlDocument.append(childNode.getNodeName());
            childNodeAttributes = childNode.getAttributes();
            attributeCount = childNodeAttributes.getLength();
            for (attributeIndex = 0; attributeIndex < attributeCount; ++attributeIndex) {
                attribute = childNodeAttributes.item(attributeIndex);
                logger.log(Level.FINER, "adding attribute: " + attribute.getNodeName() + " = " + attribute.getNodeValue());
                newXML.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
            }
            SimpleXML.addDocumentChildren(newXML, childNode);
        }
        return xmlDocument;
    }
}

