/*
 * Decompiled with CFR 0.152.
 */
package net.pterodactylus.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.pterodactylus.util.io.Closer;
import net.pterodactylus.util.logging.Logging;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XML {
    private static final Logger logger = Logging.getLogger(XML.class.getName());
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transformerFactory = null;

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory != null) {
            return documentBuilderFactory;
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setXIncludeAware(true);
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException pce1) {
            logger.log(Level.WARNING, "Could not disable external DTD loading.", pce1);
        }
        return documentBuilderFactory;
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder != null) {
            return documentBuilder;
        }
        try {
            documentBuilder = XML.getDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce1) {
            logger.log(Level.WARNING, "Could not create DocumentBuilder.", pce1);
        }
        return documentBuilder;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory != null) {
            return transformerFactory;
        }
        transformerFactory = TransformerFactory.newInstance();
        return transformerFactory;
    }

    public static Document createDocument() {
        return XML.getDocumentBuilder().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transformToByteArray(Document document) {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        OutputStreamWriter converter = new OutputStreamWriter((OutputStream)byteOutput, Charset.forName("UTF-8"));
        XML.writeToOutputStream(document, converter);
        try {
            byte[] result;
            converter.flush();
            byteOutput.flush();
            byte[] byArray = result = byteOutput.toByteArray();
            return byArray;
        }
        catch (IOException ioe1) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            Closer.close(converter);
            Closer.close(byteOutput);
        }
    }

    public static void writeToOutputStream(Document document, Writer writer) {
        XML.writeToOutputStream(document, writer, true);
    }

    public static void writeToOutputStream(Document document, Writer writer, boolean preamble) {
        StreamResult transformResult = new StreamResult(writer);
        DOMSource documentSource = new DOMSource(document);
        try {
            Transformer transformer = XML.getTransformerFactory().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", preamble ? "no" : "yes");
            transformer.transform(documentSource, transformResult);
        }
        catch (TransformerConfigurationException tce1) {
            logger.log(Level.WARNING, "Could create Transformer.", tce1);
        }
        catch (TransformerException te1) {
            logger.log(Level.WARNING, "Could not transform Document.", te1);
        }
    }

    public static Document transformToDocument(byte[] data) {
        return XML.transformToDocument(new ByteArrayInputStream(data));
    }

    public static Document transformToDocument(InputStream inputStream) {
        return XML.transformToDocument(new InputSource(inputStream));
    }

    public static Document transformToDocument(Reader inputReader) {
        return XML.transformToDocument(new InputSource(inputReader));
    }

    public static Document transformToDocument(InputSource inputSource) {
        try {
            DocumentBuilder documentBuilder = XML.getDocumentBuilder();
            return documentBuilder.parse(inputSource);
        }
        catch (SAXException saxe1) {
            logger.log(Level.WARNING, "Could not parse InputSource.", saxe1);
        }
        catch (IOException ioe1) {
            logger.log(Level.WARNING, "Could not read InputSource.", ioe1);
        }
        return null;
    }
}

