/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.mime.DefaultMIMETypes;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ProjectFilesPage
extends TWizardPage
implements ActionListener,
ListSelectionListener,
DocumentListener,
FileScannerListener,
ChangeListener {
    private Project project;
    private Action scanAction;
    private Action editContainerAction;
    private Action addContainerAction;
    protected Action deleteContainerAction;
    private JList projectFileList;
    private JCheckBox defaultFileCheckBox;
    private JCheckBox fileOptionsInsertCheckBox;
    private JTextField fileOptionsCustomKeyTextField;
    private JComboBox fileOptionsMIMETypeComboBox;
    private DefaultComboBoxModel containerComboBoxModel;
    private JComboBox fileOptionsContainerComboBox;
    private JSpinner replaceEditionRangeSpinner;
    private JCheckBox replacementCheckBox;

    public ProjectFilesPage(TWizard tWizard) {
        super(tWizard);
        this.pageInit();
    }

    private void pageInit() {
        this.createActions();
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createProjectFilesPanel(), "Center");
    }

    private void createActions() {
        this.scanAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.rescan")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionScan();
            }
        };
        this.scanAction.putValue("MnemonicKey", 83);
        this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
        this.addContainerAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.add-container")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionAddContainer();
            }
        };
        this.addContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.add-container.tooltip"));
        this.addContainerAction.setEnabled(false);
        this.editContainerAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.edit-container")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionEditContainer();
            }
        };
        this.editContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.edit-container.tooltip"));
        this.editContainerAction.setEnabled(false);
        this.deleteContainerAction = new AbstractAction(I18n.getMessage("jsite.project-files.action.delete-container")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectFilesPage.this.actionDeleteContainer();
            }
        };
        this.deleteContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.delete-container.tooltip"));
        this.deleteContainerAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.scanAction.putValue("Name", I18n.getMessage("jsite.project-files.action.rescan"));
                ProjectFilesPage.this.scanAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.rescan.tooltip"));
                ProjectFilesPage.this.addContainerAction.putValue("Name", I18n.getMessage("jsite.project-files.action.add-container"));
                ProjectFilesPage.this.addContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.add-container.tooltip"));
                ProjectFilesPage.this.editContainerAction.putValue("Name", I18n.getMessage("jsite.project-files.action.edit-container"));
                ProjectFilesPage.this.editContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.edit-container.tooltip"));
                ProjectFilesPage.this.deleteContainerAction.putValue("Name", I18n.getMessage("jsite.project-files.action.delete-container"));
                ProjectFilesPage.this.deleteContainerAction.putValue("ShortDescription", I18n.getMessage("jsite.project-files.action.delete-container.tooltip"));
            }
        });
    }

    @Override
    public void pageAdded(TWizard tWizard) {
        this.actionScan();
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setNextName(I18n.getMessage("jsite.project-files.insert-now"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    private JComponent createProjectFilesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        this.projectFileList = new JList();
        this.projectFileList.setSelectionMode(0);
        this.projectFileList.setMinimumSize(new Dimension(250, this.projectFileList.getPreferredSize().height));
        this.projectFileList.addListSelectionListener(this);
        jPanel.add((Component)new JScrollPane(this.projectFileList), "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)jPanel2, "Last");
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jPanel3, "First");
        jPanel3.add((Component)new JButton(this.scanAction), new GridBagConstraints(0, 0, 5, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
        jPanel3.add((Component)jLabel, new GridBagConstraints(0, 1, 5, 1, 1.0, 0.0, 21, 0, new Insets(6, 0, 0, 0), 0, 0));
        this.defaultFileCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.default"));
        this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
        this.defaultFileCheckBox.setName("default-file");
        this.defaultFileCheckBox.addActionListener(this);
        this.defaultFileCheckBox.setEnabled(false);
        jPanel3.add((Component)this.defaultFileCheckBox, new GridBagConstraints(0, 2, 5, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsInsertCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.insert"), true);
        this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
        this.fileOptionsInsertCheckBox.setName("insert");
        this.fileOptionsInsertCheckBox.setMnemonic(73);
        this.fileOptionsInsertCheckBox.addActionListener(this);
        this.fileOptionsInsertCheckBox.setEnabled(false);
        jPanel3.add((Component)this.fileOptionsInsertCheckBox, new GridBagConstraints(0, 3, 5, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.fileOptionsCustomKeyTextField = new JTextField(45);
        this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
        this.fileOptionsCustomKeyTextField.setEnabled(false);
        this.fileOptionsCustomKeyTextField.getDocument().addDocumentListener(this);
        final TLabel tLabel = new TLabel(I18n.getMessage("jsite.project-files.custom-key") + ":", 75, (Component)this.fileOptionsCustomKeyTextField);
        jPanel3.add((Component)tLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsCustomKeyTextField, new GridBagConstraints(1, 4, 4, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.fileOptionsMIMETypeComboBox = new JComboBox<String>(DefaultMIMETypes.getAllMIMETypes());
        this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
        this.fileOptionsMIMETypeComboBox.setName("project-files.mime-type");
        this.fileOptionsMIMETypeComboBox.addActionListener(this);
        this.fileOptionsMIMETypeComboBox.setEditable(true);
        this.fileOptionsMIMETypeComboBox.setEnabled(false);
        final TLabel tLabel2 = new TLabel(I18n.getMessage("jsite.project-files.mime-type") + ":", 77, (Component)this.fileOptionsMIMETypeComboBox);
        jPanel3.add((Component)tLabel2, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsMIMETypeComboBox, new GridBagConstraints(1, 5, 4, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.containerComboBoxModel = new DefaultComboBoxModel();
        this.fileOptionsContainerComboBox = new JComboBox(this.containerComboBoxModel);
        this.fileOptionsContainerComboBox.setToolTipText(I18n.getMessage("jsite.project-files.container.tooltip"));
        this.fileOptionsContainerComboBox.setName("project-files.container");
        this.fileOptionsContainerComboBox.addActionListener(this);
        this.fileOptionsContainerComboBox.setEnabled(false);
        this.fileOptionsContainerComboBox.setVisible(false);
        final TLabel tLabel3 = new TLabel(I18n.getMessage("jsite.project-files.container") + ":", 67, (Component)this.fileOptionsContainerComboBox);
        tLabel3.setVisible(false);
        JButton jButton = new JButton(this.addContainerAction);
        jButton.setVisible(false);
        JButton jButton2 = new JButton(this.editContainerAction);
        jButton2.setVisible(false);
        JButton jButton3 = new JButton(this.deleteContainerAction);
        jButton3.setVisible(false);
        jPanel3.add((Component)tLabel3, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel3.add((Component)this.fileOptionsContainerComboBox, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)jButton, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)jButton2, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel3.add((Component)jButton3, new GridBagConstraints(4, 6, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        JPanel jPanel4 = new JPanel(new FlowLayout(3, 6, 6));
        jPanel4.setBorder(new EmptyBorder(-6, -6, -6, -6));
        this.replacementCheckBox = new JCheckBox(I18n.getMessage("jsite.project-files.replacement"));
        this.replacementCheckBox.setName("project-files.replace-edition");
        this.replacementCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.replacement.tooltip"));
        this.replacementCheckBox.addActionListener(this);
        this.replacementCheckBox.setEnabled(false);
        this.replacementCheckBox.setVisible(false);
        jPanel4.add(this.replacementCheckBox);
        this.replaceEditionRangeSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        this.replaceEditionRangeSpinner.setName("project-files.replace-edition-range");
        this.replaceEditionRangeSpinner.setToolTipText(I18n.getMessage("jsite.project-files.replacement.edition-range.tooltip"));
        this.replaceEditionRangeSpinner.addChangeListener(this);
        this.replaceEditionRangeSpinner.setEnabled(false);
        this.replaceEditionRangeSpinner.setVisible(false);
        final JLabel jLabel2 = new JLabel(I18n.getMessage("jsite.project-files.replacement.edition-range"));
        jLabel2.setVisible(false);
        jPanel4.add(jLabel2);
        jPanel4.add(this.replaceEditionRangeSpinner);
        jPanel3.add((Component)jPanel4, new GridBagConstraints(0, 7, 5, 1, 1.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.project-files.file-options") + "</b></html>");
                ProjectFilesPage.this.defaultFileCheckBox.setText(I18n.getMessage("jsite.project-files.default"));
                ProjectFilesPage.this.defaultFileCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.default.tooltip"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setText(I18n.getMessage("jsite.project-files.insert"));
                ProjectFilesPage.this.fileOptionsInsertCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.insert.tooltip"));
                ProjectFilesPage.this.fileOptionsCustomKeyTextField.setToolTipText(I18n.getMessage("jsite.project-files.custom-key.tooltip"));
                tLabel.setText(I18n.getMessage("jsite.project-files.custom-key") + ":");
                ProjectFilesPage.this.fileOptionsMIMETypeComboBox.setToolTipText(I18n.getMessage("jsite.project-files.mime-type.tooltip"));
                tLabel2.setText(I18n.getMessage("jsite.project-files.mime-type") + ":");
                ProjectFilesPage.this.fileOptionsContainerComboBox.setToolTipText(I18n.getMessage("jsite.project-files.container.tooltip"));
                tLabel3.setText(I18n.getMessage("jsite.project-files.container") + ":");
                ProjectFilesPage.this.replacementCheckBox.setText(I18n.getMessage("jsite.project-files.replacement"));
                ProjectFilesPage.this.replacementCheckBox.setToolTipText(I18n.getMessage("jsite.project-files.replacement.tooltip"));
                ProjectFilesPage.this.replaceEditionRangeSpinner.setToolTipText(I18n.getMessage("jsite.project-files.replacement.edition-range.tooltip"));
                jLabel2.setText(I18n.getMessage("jsite.project-files.replacement.edition-range"));
            }
        });
        return jPanel;
    }

    public void setProject(final Project project) {
        this.project = project;
        this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
        this.setDescription(I18n.getMessage("jsite.project-files.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.setHeading(MessageFormat.format(I18n.getMessage("jsite.project-files.heading"), project.getName()));
                ProjectFilesPage.this.setDescription(I18n.getMessage("jsite.project-files.description"));
            }
        });
    }

    private List<String> getProjectFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.projectFileList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            arrayList.add((String)this.projectFileList.getModel().getElementAt(i));
        }
        return arrayList;
    }

    private void rebuildContainerComboBox() {
        List<String> list = this.getProjectFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        for (String string : list) {
            String string2 = this.project.getFileOption(string).getContainer();
            if (arrayList.contains(string2)) continue;
            arrayList.add(string2);
        }
        Collections.sort(arrayList);
        this.containerComboBoxModel.removeAllElements();
        for (String string : arrayList) {
            this.containerComboBoxModel.addElement(string);
        }
    }

    private void actionScan() {
        this.projectFileList.clearSelection();
        this.projectFileList.setListData(new Object[0]);
        this.wizard.setNextEnabled(false);
        this.wizard.setPreviousEnabled(false);
        this.wizard.setQuitEnabled(false);
        FileScanner fileScanner = new FileScanner(this.project);
        fileScanner.addFileScannerListener(this);
        new Thread(fileScanner).start();
    }

    private void actionAddContainer() {
        String string = JOptionPane.showInputDialog(this.wizard, I18n.getMessage("jsite.project-files.action.add-container.message") + ":", null, 1);
        if (string == null) {
            return;
        }
        string = string.trim();
        String string2 = (String)this.projectFileList.getSelectedValue();
        FileOption fileOption = this.project.getFileOption(string2);
        fileOption.setContainer(string);
        this.rebuildContainerComboBox();
        this.fileOptionsContainerComboBox.setSelectedItem(string);
    }

    private void actionEditContainer() {
        String string = (String)this.projectFileList.getSelectedValue();
        FileOption fileOption = this.project.getFileOption(string);
        String string2 = fileOption.getContainer();
        String string3 = JOptionPane.showInputDialog(this.wizard, I18n.getMessage("jsite.project-files.action.edit-container.message") + ":", string2);
        if (string3 == null) {
            return;
        }
        if (string3.equals("")) {
            fileOption.setContainer("");
            this.fileOptionsContainerComboBox.setSelectedItem("");
            return;
        }
        List<String> list = this.getProjectFiles();
        for (String string4 : list) {
            fileOption = this.project.getFileOption(string4);
            if (!fileOption.getContainer().equals(string2)) continue;
            fileOption.setContainer(string3);
        }
        this.rebuildContainerComboBox();
        this.fileOptionsContainerComboBox.setSelectedItem(string3);
    }

    private void actionDeleteContainer() {
        if (JOptionPane.showConfirmDialog(this.wizard, I18n.getMessage("jsite.project-files.action.delete-container.message"), null, 2, 2) == 0) {
            String string = (String)this.fileOptionsContainerComboBox.getSelectedItem();
            List<String> list = this.getProjectFiles();
            for (String string2 : list) {
                FileOption fileOption = this.project.getFileOption(string2);
                if (!fileOption.getContainer().equals(string)) continue;
                fileOption.setContainer("");
            }
            this.fileOptionsContainerComboBox.setSelectedItem("");
        }
    }

    @Override
    public void fileScannerFinished(FileScanner fileScanner) {
        final boolean bl = fileScanner.isError();
        if (!bl) {
            final List<String> list = fileScanner.getFiles();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProjectFilesPage.this.projectFileList.setListData(list.toArray(new String[list.size()]));
                    ProjectFilesPage.this.projectFileList.clearSelection();
                    ProjectFilesPage.this.rebuildContainerComboBox();
                }
            });
            HashSet<String> hashSet = new HashSet<String>();
            for (String object : this.project.getFileOptions().keySet()) {
                if (list.contains(object)) continue;
                hashSet.add(object);
            }
            for (String string : hashSet) {
                this.project.setFileOption(string, null);
            }
        } else {
            JOptionPane.showMessageDialog(this.wizard, I18n.getMessage("jsite.project-files.scan-error"), null, 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectFilesPage.this.wizard.setPreviousEnabled(true);
                ProjectFilesPage.this.wizard.setNextEnabled(!bl);
                ProjectFilesPage.this.wizard.setQuitEnabled(true);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.projectFileList.getSelectedValue();
        if (string == null) {
            return;
        }
        FileOption fileOption = this.project.getFileOption(string);
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)object;
            if ("default-file".equals(jCheckBox.getName())) {
                if (jCheckBox.isSelected()) {
                    this.project.setIndexFile(string);
                } else {
                    this.project.setIndexFile(null);
                }
            } else if ("insert".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                this.fileOptionsCustomKeyTextField.setEnabled(!bl);
                fileOption.setInsert(bl);
                if (!bl) {
                    this.fileOptionsContainerComboBox.setSelectedItem("");
                }
            } else if ("project-files.replace-edition".equals(jCheckBox.getName())) {
                boolean bl = jCheckBox.isSelected();
                fileOption.setReplaceEdition(bl);
                this.replaceEditionRangeSpinner.setEnabled(bl);
            }
        } else if (object instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)object;
            if ("project-files.mime-type".equals(jComboBox.getName())) {
                fileOption.setMimeType((String)jComboBox.getSelectedItem());
            } else if ("project-files.container".equals(jComboBox.getName())) {
                String string2 = (String)jComboBox.getSelectedItem();
                fileOption.setContainer(string2);
                boolean bl = !"".equals(string2);
                this.editContainerAction.setEnabled(bl);
                this.deleteContainerAction.setEnabled(bl);
                if (bl) {
                    this.fileOptionsInsertCheckBox.setSelected(true);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string = (String)this.projectFileList.getSelectedValue();
        boolean bl = string != null;
        boolean bl2 = this.fileOptionsInsertCheckBox.isSelected();
        this.defaultFileCheckBox.setEnabled(bl);
        this.fileOptionsInsertCheckBox.setEnabled(bl);
        this.fileOptionsCustomKeyTextField.setEnabled(bl && !bl2);
        this.fileOptionsMIMETypeComboBox.setEnabled(bl);
        this.fileOptionsContainerComboBox.setEnabled(bl);
        this.addContainerAction.setEnabled(bl);
        this.editContainerAction.setEnabled(bl);
        this.deleteContainerAction.setEnabled(bl);
        this.replacementCheckBox.setEnabled(bl && bl2);
        if (string != null) {
            FileOption fileOption = this.project.getFileOption(string);
            this.defaultFileCheckBox.setSelected(string.equals(this.project.getIndexFile()));
            this.fileOptionsInsertCheckBox.setSelected(fileOption.isInsert());
            this.fileOptionsCustomKeyTextField.setText(fileOption.getCustomKey());
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem(fileOption.getMimeType());
            this.fileOptionsContainerComboBox.setSelectedItem(fileOption.getContainer());
            this.replacementCheckBox.setSelected(fileOption.getReplaceEdition());
            this.replaceEditionRangeSpinner.setValue(fileOption.getEditionRange());
            this.replaceEditionRangeSpinner.setEnabled(fileOption.getReplaceEdition());
        } else {
            this.defaultFileCheckBox.setSelected(false);
            this.fileOptionsInsertCheckBox.setSelected(true);
            this.fileOptionsCustomKeyTextField.setText("CHK@");
            this.fileOptionsMIMETypeComboBox.getModel().setSelectedItem("application/octet-stream");
            this.fileOptionsContainerComboBox.setSelectedItem("");
            this.replacementCheckBox.setSelected(false);
            this.replaceEditionRangeSpinner.setValue(0);
        }
    }

    private void processDocumentUpdate(DocumentEvent documentEvent) {
        String string = (String)this.projectFileList.getSelectedValue();
        if (string == null) {
            return;
        }
        FileOption fileOption = this.project.getFileOption(string);
        Document document = documentEvent.getDocument();
        try {
            String string2 = document.getText(0, document.getLength());
            fileOption.setCustomKey(string2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.processDocumentUpdate(documentEvent);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        String string = (String)this.projectFileList.getSelectedValue();
        if (string == null) {
            return;
        }
        FileOption fileOption = this.project.getFileOption(string);
        Object object = changeEvent.getSource();
        if (object instanceof JSpinner) {
            JSpinner jSpinner = (JSpinner)object;
            fileOption.setEditionRange((Integer)jSpinner.getValue());
        }
    }
}

