/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.ClientHello;
import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.ConnectionListener;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.Node;
import de.todesbaum.util.io.Closer;
import de.todesbaum.util.io.LineInputStream;
import de.todesbaum.util.io.StreamCopier;
import de.todesbaum.util.io.TempFileInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class Connection {
    private List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private final Node node;
    private final String name;
    private Socket nodeSocket;
    private InputStream nodeInputStream;
    private OutputStream nodeOutputStream;
    private NodeReader nodeReader;
    private Writer nodeWriter;
    protected Message nodeHello;

    public Connection(Node node, String string) {
        this.node = node;
        this.name = string;
    }

    public void addConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.add(connectionListener);
    }

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected void fireMessageReceived(Message message) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.messageReceived(this, message);
        }
    }

    protected void fireConnectionTerminated() {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            connectionListener.connectionTerminated(this);
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean connect() throws IOException {
        this.nodeSocket = null;
        this.nodeInputStream = null;
        this.nodeOutputStream = null;
        this.nodeWriter = null;
        this.nodeReader = null;
        try {
            this.nodeSocket = new Socket(this.node.getHostname(), this.node.getPort());
            this.nodeSocket.setReceiveBufferSize(65535);
            this.nodeInputStream = this.nodeSocket.getInputStream();
            this.nodeOutputStream = this.nodeSocket.getOutputStream();
            this.nodeWriter = new OutputStreamWriter(this.nodeOutputStream, Charset.forName("UTF-8"));
            this.nodeReader = new NodeReader(this.nodeInputStream);
            Thread thread = new Thread(this.nodeReader);
            thread.setDaemon(true);
            thread.start();
            ClientHello clientHello = new ClientHello();
            clientHello.setName(this.name);
            clientHello.setExpectedVersion("2.0");
            this.execute(clientHello);
            Connection connection = this;
            synchronized (connection) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.nodeHello != null;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public boolean isConnected() {
        return this.nodeHello != null && this.nodeSocket != null && this.nodeSocket.isConnected();
    }

    public Message getNodeHello() {
        return this.nodeHello;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.nodeWriter != null) {
            try {
                this.nodeWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nodeWriter = null;
        }
        if (this.nodeOutputStream != null) {
            try {
                this.nodeOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nodeOutputStream = null;
        }
        if (this.nodeInputStream != null) {
            try {
                this.nodeInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nodeInputStream = null;
        }
        if (this.nodeSocket != null) {
            try {
                this.nodeSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.nodeSocket = null;
        }
        Connection connection = this;
        synchronized (connection) {
            this.notify();
        }
        this.fireConnectionTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Command command) throws IllegalStateException, IOException {
        if (this.nodeSocket == null) {
            throw new IllegalStateException("connection is not connected");
        }
        this.nodeWriter.write(command.getCommandName() + "\r\n");
        command.write(this.nodeWriter);
        this.nodeWriter.write("EndMessage\r\n");
        this.nodeWriter.flush();
        if (command.hasPayload()) {
            InputStream inputStream = null;
            try {
                inputStream = command.getPayload();
                StreamCopier.copy(inputStream, this.nodeOutputStream, command.getPayloadLength());
            }
            finally {
                Closer.close(inputStream);
            }
            this.nodeOutputStream.flush();
        }
    }

    private class NodeReader
    implements Runnable {
        private InputStream nodeInputStream;

        public NodeReader(InputStream inputStream) {
            this.nodeInputStream = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LineInputStream lineInputStream = null;
            try {
                lineInputStream = new LineInputStream(this.nodeInputStream);
                String string = "";
                Message message = null;
                while (string != null) {
                    Object object;
                    Object object2;
                    string = lineInputStream.readLine();
                    if (string == null) {
                        break;
                    }
                    if (message == null) {
                        message = new Message(string);
                        continue;
                    }
                    if ("Data".equals(string)) {
                        object2 = null;
                        try {
                            object2 = File.createTempFile("fcpv2", "data");
                            ((File)object2).deleteOnExit();
                            object = new FileOutputStream((File)object2);
                            long l = Long.parseLong(message.get("DataLength"));
                            StreamCopier.copy(this.nodeInputStream, (OutputStream)object, l);
                            ((FileOutputStream)object).close();
                            message.setPayloadInputStream(new TempFileInputStream((File)object2));
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if ("Data".equals(string) || "EndMessage".equals(string)) {
                        if (message.getName().equals("NodeHello")) {
                            Connection.this.nodeHello = message;
                            object2 = Connection.this;
                            synchronized (object2) {
                                Connection.this.notify();
                            }
                        } else {
                            Connection.this.fireMessageReceived(message);
                        }
                        message = null;
                        continue;
                    }
                    int n = string.indexOf(61);
                    if (n > -1) {
                        object = string.substring(0, n).trim();
                        String string2 = string.substring(n + 1).trim();
                        if (((String)object).equals("Identifier")) {
                            message.setIdentifier(string2);
                            continue;
                        }
                        message.put((String)object, string2);
                        continue;
                    }
                    if (string.trim().length() == 0) continue;
                    throw new IOException("Unexpected line: " + string);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (lineInputStream != null) {
                    try {
                        lineInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.nodeInputStream != null) {
                    try {
                        this.nodeInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Connection.this.disconnect();
        }
    }
}

