/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.NodeManagerListener;
import de.todesbaum.jsite.gui.NodeManagerPage;
import de.todesbaum.jsite.gui.ProjectFilesPage;
import de.todesbaum.jsite.gui.ProjectInsertPage;
import de.todesbaum.jsite.gui.ProjectPage;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.jsite.main.Configuration;
import de.todesbaum.jsite.main.Version;
import de.todesbaum.util.image.IconLoader;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import de.todesbaum.util.swing.WizardListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Main
implements ActionListener,
ListSelectionListener,
WizardListener,
NodeManagerListener {
    private static boolean debug = false;
    private Configuration configuration;
    private Freenet7Interface freenetInterface = new Freenet7Interface();
    private Icon jSiteIcon;
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, new Locale("pl")};
    private Map<Locale, Action> languageActions = new HashMap<Locale, Action>();
    private Action manageNodeAction;
    private Action aboutAction;
    private TWizard wizard;
    private JMenu nodeMenu;
    private Node selectedNode;
    private final Map<PageType, TWizardPage> pages = new HashMap<PageType, TWizardPage>();

    private Main() {
        this(null);
    }

    private Main(String string) {
        this.configuration = string != null ? new Configuration(string) : new Configuration();
        Locale.setDefault(this.configuration.getLocale());
        I18n.setLocale(this.configuration.getLocale());
        if (!this.configuration.createLockFile()) {
            JOptionPane.showMessageDialog(null, I18n.getMessage("jsite.main.already-running"), null, 0);
            return;
        }
        this.wizard = new TWizard();
        this.createActions();
        this.wizard.setJMenuBar(this.createMenuBar());
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setNextEnabled(true);
        this.wizard.addWizardListener(this);
        this.jSiteIcon = IconLoader.loadIcon("/jsite-icon.png");
        this.wizard.setIcon(this.jSiteIcon);
        this.initPages();
        this.showPage(PageType.PAGE_PROJECTS);
    }

    private void createActions() {
        for (final Locale locale : SUPPORTED_LOCALES) {
            this.languageActions.put(locale, new AbstractAction(I18n.getMessage("jsite.menu.language." + locale.getLanguage()), IconLoader.loadIcon("/flag-" + locale.getLanguage() + ".png")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.switchLanguage(locale);
                }
            });
        }
        this.manageNodeAction = new AbstractAction(I18n.getMessage("jsite.menu.nodes.manage-nodes")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.showPage(PageType.PAGE_NODE_MANAGER);
                Main.this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
                Main.this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
            }
        };
        this.aboutAction = new AbstractAction(I18n.getMessage("jsite.menu.help.about")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(Main.this.wizard, MessageFormat.format(I18n.getMessage("jsite.about.message"), Version.getVersion()), null, 1, Main.this.jSiteIcon);
            }
        };
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                Main.this.manageNodeAction.putValue("Name", I18n.getMessage("jsite.menu.nodes.manage-nodes"));
                Main.this.aboutAction.putValue("Name", I18n.getMessage("jsite.menu.help.about"));
            }
        });
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        final JMenu jMenu = new JMenu(I18n.getMessage("jsite.menu.languages"));
        jMenuBar.add(jMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Locale locale : SUPPORTED_LOCALES) {
            Action action = this.languageActions.get(locale);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.languageActions.get(locale));
            if (locale.equals(Locale.getDefault())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            action.putValue("menuItem", jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        this.nodeMenu = new JMenu(I18n.getMessage("jsite.menu.nodes"));
        jMenuBar.add(this.nodeMenu);
        this.selectedNode = this.configuration.getSelectedNode();
        this.nodesUpdated(this.configuration.getNodes());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jMenuBar.add(jPanel);
        final JMenu jMenu2 = new JMenu(I18n.getMessage("jsite.menu.help"));
        jMenuBar.add(jMenu2);
        jMenu2.add(this.aboutAction);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jMenu.setText(I18n.getMessage("jsite.menu.languages"));
                Main.this.nodeMenu.setText(I18n.getMessage("jsite.menu.nodes"));
                jMenu2.setText(I18n.getMessage("jsite.menu.help"));
                for (Map.Entry entry : Main.this.languageActions.entrySet()) {
                    ((Action)entry.getValue()).putValue("Name", I18n.getMessage("jsite.menu.language." + ((Locale)entry.getKey()).getLanguage()));
                }
            }
        });
        return jMenuBar;
    }

    private void initPages() {
        NodeManagerPage nodeManagerPage = new NodeManagerPage(this.wizard);
        nodeManagerPage.setName("page.node-manager");
        nodeManagerPage.addNodeManagerListener(this);
        nodeManagerPage.setNodes(this.configuration.getNodes());
        this.pages.put(PageType.PAGE_NODE_MANAGER, nodeManagerPage);
        ProjectPage projectPage = new ProjectPage(this.wizard);
        projectPage.setName("page.project");
        projectPage.setProjects(this.configuration.getProjects());
        projectPage.setFreenetInterface(this.freenetInterface);
        projectPage.addListSelectionListener(this);
        this.pages.put(PageType.PAGE_PROJECTS, projectPage);
        ProjectFilesPage projectFilesPage = new ProjectFilesPage(this.wizard);
        projectFilesPage.setName("page.project.files");
        this.pages.put(PageType.PAGE_PROJECT_FILES, projectFilesPage);
        ProjectInsertPage projectInsertPage = new ProjectInsertPage(this.wizard);
        projectInsertPage.setDebug(debug);
        projectInsertPage.setName("page.project.insert");
        projectInsertPage.setFreenetInterface(this.freenetInterface);
        this.pages.put(PageType.PAGE_INSERT_PROJECT, projectInsertPage);
    }

    private void showPage(PageType pageType) {
        this.wizard.setPreviousEnabled(pageType.ordinal() > 0);
        this.wizard.setNextEnabled(pageType.ordinal() < this.pages.size() - 1);
        this.wizard.setPage(this.pages.get((Object)pageType));
        this.wizard.setTitle(this.pages.get((Object)pageType).getHeading() + " - jSite");
    }

    private boolean saveConfiguration() {
        NodeManagerPage nodeManagerPage = (NodeManagerPage)this.pages.get((Object)PageType.PAGE_NODE_MANAGER);
        this.configuration.setNodes(nodeManagerPage.getNodes());
        if (this.selectedNode != null) {
            this.configuration.setSelectedNode(this.selectedNode);
        }
        ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
        this.configuration.setProjects(projectPage.getProjects());
        return this.configuration.save();
    }

    private Locale findSupportedLocale(Locale locale) {
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.equals(locale)) continue;
            return locale2;
        }
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.getCountry().equals(locale.getCountry()) || !locale2.getLanguage().equals(locale.getLanguage())) continue;
            return locale2;
        }
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return locale2;
        }
        return SUPPORTED_LOCALES[0];
    }

    private void switchLanguage(Locale locale) {
        Locale locale2 = this.findSupportedLocale(locale);
        Action action = this.languageActions.get(locale2);
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)action.getValue("menuItem");
        jRadioButtonMenuItem.setSelected(true);
        I18n.setLocale(locale2);
        for (Runnable runnable : I18nContainer.getInstance()) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {}
        }
        this.wizard.setPage(this.wizard.getPage());
        this.configuration.setLocale(locale2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getSelectedIndex();
        this.wizard.setNextEnabled(n > -1);
    }

    @Override
    public void wizardNextPressed(TWizard tWizard) {
        String string = tWizard.getPage().getName();
        if ("page.node-manager".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project".equals(string)) {
            ProjectPage projectPage = (ProjectPage)tWizard.getPage();
            Project project = projectPage.getSelectedProject();
            if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project.warning.no-local-path"), null, 0);
                return;
            }
            if (project.getPath() == null || project.getPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project.warning.no-path"), null, 0);
                return;
            }
            ((ProjectFilesPage)this.pages.get((Object)PageType.PAGE_PROJECT_FILES)).setProject(project);
            ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).setProject(project);
            this.showPage(PageType.PAGE_PROJECT_FILES);
        } else if ("page.project.files".equals(string)) {
            boolean bl;
            Object object;
            ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
            Project project = projectPage.getSelectedProject();
            if (this.selectedNode == null) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project-files.no-node-selected"), null, 0);
                return;
            }
            if (project.getIndexFile() == null) {
                if (JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.project-files.empty-index"), null, 2, 2) != 0) {
                    return;
                }
            } else {
                object = new File(project.getLocalPath(), project.getIndexFile());
                if (!((File)object).exists()) {
                    JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project-files.index-missing"), null, 0);
                    return;
                }
            }
            boolean bl2 = bl = (object = project.getIndexFile()) != null;
            if (bl && !project.getFileOption((String)object).getContainer().equals("") && JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.project-files.container-index"), null, 2, 2) != 0) {
                return;
            }
            if (bl && !project.getFileOption((String)object).getMimeType().equals("text/html") && JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.project-files.index-not-html"), null, 2, 2) != 0) {
                return;
            }
            Map<String, FileOption> map = project.getFileOptions();
            Set<Map.Entry<String, FileOption>> set = map.entrySet();
            for (Map.Entry<String, FileOption> entry : set) {
                FileOption fileOption = entry.getValue();
                if (fileOption.isInsert() || fileOption.getCustomKey().length() != 0 && !"CHK@".equals(fileOption.getCustomKey())) continue;
                JOptionPane.showMessageDialog(tWizard, MessageFormat.format(I18n.getMessage("jsite.project-files.no-custom-key"), entry.getKey()), null, 0);
                return;
            }
            boolean bl3 = false;
            try {
                bl3 = this.freenetInterface.isNodePresent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl3) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project-files.no-node-running"), null, 0);
                return;
            }
            this.configuration.save();
            this.showPage(PageType.PAGE_INSERT_PROJECT);
            ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).startInsert();
            this.nodeMenu.setEnabled(false);
        } else if ("page.project.insert".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
            this.nodeMenu.setEnabled(true);
        }
    }

    @Override
    public void wizardPreviousPressed(TWizard tWizard) {
        String string = tWizard.getPage().getName();
        if ("page.project".equals(string)) {
            this.showPage(PageType.PAGE_NODE_MANAGER);
        } else if ("page.project.files".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project.insert".equals(string)) {
            this.showPage(PageType.PAGE_PROJECT_FILES);
        }
    }

    @Override
    public void wizardQuitPressed(TWizard tWizard) {
        if (JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.quit.question"), null, 2, 3) == 0) {
            if (this.saveConfiguration()) {
                System.exit(0);
            }
            if (JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.quit.config-not-saved"), null, 2, 2) == 0) {
                System.exit(0);
            }
        }
    }

    @Override
    public void nodesUpdated(Node[] nodeArray) {
        this.nodeMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        Node node = null;
        for (Node node2 : nodeArray) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(node2.getName());
            jRadioButtonMenuItem.putClientProperty("Node", node2);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            if (node2.equals(this.selectedNode)) {
                node = node2;
                jRadioButtonMenuItem.setSelected(true);
            }
            this.nodeMenu.add(jRadioButtonMenuItem);
        }
        this.nodeMenu.addSeparator();
        this.nodeMenu.add(this.manageNodeAction);
        this.selectedNode = node;
        this.freenetInterface.setNode(this.selectedNode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButtonMenuItem) {
            Node node;
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object;
            this.selectedNode = node = (Node)jRadioButtonMenuItem.getClientProperty("Node");
            this.freenetInterface.setNode(this.selectedNode);
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        boolean bl = false;
        for (String string2 : stringArray) {
            if (bl) {
                string = string2;
                bl = false;
            }
            if ("--help".equals(string2)) {
                Main.printHelp();
                return;
            }
            if ("--debug".equals(string2)) {
                debug = true;
                continue;
            }
            if (!"--config-file".equals(string2)) continue;
            bl = true;
        }
        if (bl) {
            System.out.println("--config-file needs parameter!");
            return;
        }
        new Main(string);
    }

    private static void printHelp() {
        System.out.println("--help\tshows this cruft");
        System.out.println("--debug\tenables some debug output");
        System.out.println("--config-file <file>\tuse specified configuration file");
    }

    private static enum PageType {
        PAGE_NODE_MANAGER,
        PAGE_PROJECTS,
        PAGE_PROJECT_FILES,
        PAGE_INSERT_PROJECT;

    }
}

