/*
 * jSite - a tool for uploading websites into Freenet
 * Copyright (C) 2006 David Roden
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package de.todesbaum.jsite.gui;

import java.util.EventListener;

/**
 * Listener interface for objects that want to be notified when scanning a
 * project’s local path has finished.
 * 
 * @see FileScanner
 * @author David ‘Bombe’ Roden &lt;bombe@freenetproject.org&gt;
 */
public interface FileScannerListener extends EventListener {

	/**
	 * Notifies a listener that scanning a project’s local path has finished.
	 * 
	 * @param fileScanner
	 *            The file scanner that finished
	 */
	public void fileScannerFinished(FileScanner fileScanner);

}