/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static Locale defaultLocale = new Locale("en");
    private static Locale currentLocale;

    public static Locale getLocale() {
        if (currentLocale == null) {
            currentLocale = Locale.getDefault();
        }
        return currentLocale;
    }

    public static void setLocale(Locale locale) {
        currentLocale = locale;
        Locale.setDefault(locale);
    }

    public static ResourceBundle getResourceBundle() {
        return I18n.getResourceBundle(I18n.getLocale());
    }

    public static ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("de.todesbaum.jsite.i18n.jSite", locale);
    }

    public static String getMessage(String string) {
        try {
            return I18n.getResourceBundle().getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return I18n.getResourceBundle(defaultLocale).getString(string);
            }
            catch (MissingResourceException missingResourceException2) {
                return string;
            }
        }
    }
}

