/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.util.io.Closer;
import de.todesbaum.util.io.StreamCopier;
import de.todesbaum.util.xml.SimpleXML;
import de.todesbaum.util.xml.XML;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Configuration {
    private String filename;
    private String lockFilename;
    private SimpleXML rootNode;

    public Configuration() {
        this(System.getProperty("user.home") + "/.jSite/config7");
    }

    public Configuration(String string) {
        this(string, string + ".lock");
    }

    public Configuration(String string, String string2) {
        this.filename = string;
        this.lockFilename = string2;
        this.readConfiguration();
    }

    private boolean createConfigDirectory() {
        File file = new File(this.filename).getAbsoluteFile().getParentFile();
        return file.exists() && file.isDirectory() || file.mkdirs();
    }

    public boolean createLockFile() {
        if (!this.createConfigDirectory()) {
            return false;
        }
        File file = new File(this.lockFilename);
        try {
            boolean bl = file.createNewFile();
            if (bl) {
                file.deleteOnExit();
            }
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void removeLockfileOnExit() {
        new File(this.lockFilename).deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readConfiguration() {
        File file = new File(this.filename);
        if (file.exists()) {
            ByteArrayOutputStream byteArrayOutputStream = null;
            FileInputStream fileInputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                fileInputStream = new FileInputStream(file);
                StreamCopier.copy(fileInputStream, byteArrayOutputStream, file.length());
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.rootNode = SimpleXML.fromDocument(XML.transformToDocument(byArray));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Closer.close(fileInputStream);
                Closer.close(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                Closer.close(fileInputStream);
                Closer.close(byteArrayOutputStream);
                {
                    catch (Throwable throwable) {
                        Closer.close(fileInputStream);
                        Closer.close(byteArrayOutputStream);
                        throw throwable;
                    }
                }
            }
            Closer.close(fileInputStream);
            Closer.close(byteArrayOutputStream);
            return;
        }
        this.rootNode = new SimpleXML("configuration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public boolean save() {
        boolean bl;
        Object object;
        File file = new File(this.filename);
        if (!(file.exists() || ((File)(object = file.getAbsoluteFile().getParentFile())).exists() || ((File)object).mkdirs())) {
            return false;
        }
        object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byte[] byArray = XML.transformToByteArray(this.rootNode.getDocument());
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            object = new FileOutputStream(file);
            StreamCopier.copy(byteArrayInputStream, (OutputStream)object, byArray.length);
            bl = true;
        }
        catch (IOException iOException) {
            Closer.close(byteArrayInputStream);
            Closer.close((OutputStream)object);
            catch (Throwable throwable) {
                Closer.close(byteArrayInputStream);
                Closer.close((OutputStream)object);
                throw throwable;
            }
        }
        Closer.close(byteArrayInputStream);
        Closer.close((OutputStream)object);
        return bl;
        return false;
    }

    private String getNodeValue(String[] stringArray, String string) {
        SimpleXML simpleXML;
        int n = 0;
        for (simpleXML = this.rootNode; simpleXML != null && n < stringArray.length; simpleXML = simpleXML.getNode(stringArray[n++])) {
        }
        if (simpleXML == null) {
            return string;
        }
        return simpleXML.getValue();
    }

    private int getNodeIntValue(String[] stringArray, int n) {
        try {
            return Integer.parseInt(this.getNodeValue(stringArray, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private boolean getNodeBooleanValue(String[] stringArray, boolean bl) {
        String string = this.getNodeValue(stringArray, null);
        if (string == null) {
            return bl;
        }
        return Boolean.parseBoolean(string);
    }

    @Deprecated
    public String getNodeAddress() {
        return this.getNodeValue(new String[]{"node-address"}, "localhost");
    }

    @Deprecated
    public void setNodeAddress(String string) {
        this.rootNode.replace("node-address", string);
    }

    @Deprecated
    public int getNodePort() {
        return this.getNodeIntValue(new String[]{"node-port"}, 9481);
    }

    @Deprecated
    public void setNodePort(int n) {
        this.rootNode.replace("node-port", String.valueOf(n));
    }

    public boolean isSkipNodePage() {
        return this.getNodeBooleanValue(new String[]{"skip-node-page"}, false);
    }

    public void setSkipNodePage(boolean bl) {
        this.rootNode.replace("skip-node-page", String.valueOf(bl));
    }

    public Project[] getProjects() {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        SimpleXML simpleXML = this.rootNode.getNode("project-list");
        if (simpleXML != null) {
            SimpleXML[] simpleXMLArray;
            for (SimpleXML simpleXML2 : simpleXMLArray = simpleXML.getNodes("project")) {
                try {
                    Project project = new Project();
                    arrayList.add(project);
                    project.setDescription(simpleXML2.getNode("description").getValue(""));
                    project.setIndexFile(simpleXML2.getNode("index-file").getValue(""));
                    project.setLastInsertionTime(Long.parseLong(simpleXML2.getNode("last-insertion-time").getValue("0")));
                    project.setLocalPath(simpleXML2.getNode("local-path").getValue(""));
                    project.setName(simpleXML2.getNode("name").getValue(""));
                    project.setPath(simpleXML2.getNode("path").getValue(""));
                    if (project.getPath() != null && project.getPath().indexOf("/") != -1) {
                        project.setPath(project.getPath().replaceAll("/", ""));
                    }
                    project.setEdition(Integer.parseInt(simpleXML2.getNode("edition").getValue("0")));
                    project.setInsertURI(simpleXML2.getNode("insert-uri").getValue(""));
                    project.setRequestURI(simpleXML2.getNode("request-uri").getValue(""));
                    SimpleXML simpleXML3 = simpleXML2.getNode("file-options");
                    HashMap<String, FileOption> hashMap = new HashMap<String, FileOption>();
                    if (simpleXML3 != null) {
                        SimpleXML[] simpleXMLArray2;
                        for (SimpleXML simpleXML4 : simpleXMLArray2 = simpleXML3.getNodes("file-option")) {
                            String string = simpleXML4.getNode("filename").getValue();
                            FileOption fileOption = project.getFileOption(string);
                            fileOption.setInsert(Boolean.parseBoolean(simpleXML4.getNode("insert").getValue()));
                            fileOption.setCustomKey(simpleXML4.getNode("custom-key").getValue(""));
                            fileOption.setMimeType(simpleXML4.getNode("mime-type").getValue(""));
                            fileOption.setContainer(simpleXML4.getNode("container").getValue());
                            if (simpleXML4.getNode("replace-edition") != null) {
                                fileOption.setReplaceEdition(Boolean.parseBoolean(simpleXML4.getNode("replace-edition").getValue()));
                                fileOption.setEditionRange(Integer.parseInt(simpleXML4.getNode("edition-range").getValue()));
                            }
                            hashMap.put(string, fileOption);
                        }
                    }
                    project.setFileOptions(hashMap);
                }
                catch (NumberFormatException numberFormatException) {
                    numberFormatException.printStackTrace();
                }
            }
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public void setProjects(Project[] projectArray) {
        SimpleXML simpleXML = new SimpleXML("project-list");
        for (Project project : projectArray) {
            SimpleXML simpleXML2 = simpleXML.append("project");
            simpleXML2.append("edition", String.valueOf(project.getEdition()));
            simpleXML2.append("description", project.getDescription());
            simpleXML2.append("index-file", project.getIndexFile());
            simpleXML2.append("last-insertion-time", String.valueOf(project.getLastInsertionTime()));
            simpleXML2.append("local-path", project.getLocalPath());
            simpleXML2.append("name", project.getName());
            simpleXML2.append("path", project.getPath());
            simpleXML2.append("insert-uri", project.getInsertURI());
            simpleXML2.append("request-uri", project.getRequestURI());
            SimpleXML simpleXML3 = simpleXML2.append("file-options");
            for (Map.Entry<String, FileOption> entry : project.getFileOptions().entrySet()) {
                FileOption fileOption = entry.getValue();
                if (!fileOption.isCustom()) continue;
                SimpleXML simpleXML4 = simpleXML3.append("file-option");
                simpleXML4.append("filename", entry.getKey());
                simpleXML4.append("insert", String.valueOf(fileOption.isInsert()));
                simpleXML4.append("custom-key", fileOption.getCustomKey());
                simpleXML4.append("mime-type", fileOption.getMimeType());
                simpleXML4.append("container", fileOption.getContainer());
                simpleXML4.append("replace-edition", String.valueOf(fileOption.getReplaceEdition()));
                simpleXML4.append("edition-range", String.valueOf(fileOption.getEditionRange()));
            }
        }
        this.rootNode.replace(simpleXML);
    }

    public Locale getLocale() {
        String string = this.getNodeValue(new String[]{"i18n", "language"}, "en");
        String string2 = this.getNodeValue(new String[]{"i18n", "country"}, null);
        if (string2 != null) {
            return new Locale(string, string2);
        }
        return new Locale(string);
    }

    public void setLocale(Locale locale) {
        SimpleXML simpleXML = new SimpleXML("i18n");
        if (locale.getCountry().length() != 0) {
            simpleXML.append("country", locale.getCountry());
        }
        simpleXML.append("language", locale.getLanguage());
        this.rootNode.replace(simpleXML);
    }

    public Node[] getNodes() {
        SimpleXML simpleXML = this.rootNode.getNode("nodes");
        if (simpleXML == null) {
            String string = this.getNodeAddress();
            int n = this.getNodePort();
            if (string == null) {
                string = "127.0.0.1";
                n = 9481;
            }
            return new Node[]{new Node(string, n, "Node")};
        }
        SimpleXML[] simpleXMLArray = simpleXML.getNodes("node");
        Node[] nodeArray = new Node[simpleXMLArray.length];
        int n = 0;
        for (SimpleXML simpleXML2 : simpleXMLArray) {
            String string = simpleXML2.getNode("name").getValue();
            String string2 = simpleXML2.getNode("hostname").getValue();
            int n2 = Integer.parseInt(simpleXML2.getNode("port").getValue());
            Node node = new Node(string2, n2, string);
            nodeArray[n++] = node;
        }
        return nodeArray;
    }

    public void setNodes(Node[] nodeArray) {
        SimpleXML simpleXML = new SimpleXML("nodes");
        for (Node node : nodeArray) {
            SimpleXML simpleXML2 = simpleXML.append("node");
            simpleXML2.append("name", node.getName());
            simpleXML2.append("hostname", node.getHostname());
            simpleXML2.append("port", String.valueOf(node.getPort()));
        }
        this.rootNode.replace(simpleXML);
        this.rootNode.remove("node-address");
        this.rootNode.remove("node-port");
    }

    public void setSelectedNode(Node node) {
        SimpleXML simpleXML = new SimpleXML("selected-node");
        simpleXML.append("name", node.getName());
        simpleXML.append("hostname", node.getHostname());
        simpleXML.append("port", String.valueOf(node.getPort()));
        this.rootNode.replace(simpleXML);
    }

    public Node getSelectedNode() {
        SimpleXML simpleXML = this.rootNode.getNode("selected-node");
        if (simpleXML == null) {
            String string = this.getNodeAddress();
            int n = this.getNodePort();
            if (string == null) {
                string = "127.0.0.1";
                n = 9481;
            }
            return new Node(string, n, "Node");
        }
        String string = simpleXML.getNode("name").getValue();
        String string2 = simpleXML.getNode("hostname").getValue();
        int n = Integer.valueOf(simpleXML.getNode("port").getValue());
        return new Node(string2, n, string);
    }

    public String getTempDirectory() {
        return this.getNodeValue(new String[]{"temp-directory"}, null);
    }

    public void setTempDirectory(String string) {
        if (string != null) {
            SimpleXML simpleXML = new SimpleXML("temp-directory");
            simpleXML.setValue(string);
            this.rootNode.replace(simpleXML);
        } else {
            this.rootNode.remove("temp-directory");
        }
    }
}

