/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class PreferencesPage
extends TWizardPage {
    private Action selectDefaultTempDirectoryAction;
    private Action selectCustomTempDirectoryAction;
    private Action chooseTempDirectoryAction;
    private JTextField tempDirectoryTextField;
    private String tempDirectory;
    private JRadioButton defaultTempDirectory;
    private JRadioButton customTempDirectory;

    public PreferencesPage(TWizard tWizard) {
        super(tWizard);
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.preferences.heading"));
        this.setDescription(I18n.getMessage("jsite.preferences.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                PreferencesPage.this.setHeading(I18n.getMessage("jsite.preferences.heading"));
                PreferencesPage.this.setDescription(I18n.getMessage("jsite.preferences.description"));
            }
        });
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String string) {
        this.tempDirectory = string;
        this.tempDirectoryTextField.setText(string != null ? string : "");
        if (string != null) {
            this.customTempDirectory.setSelected(true);
            this.chooseTempDirectoryAction.setEnabled(true);
        } else {
            this.defaultTempDirectory.setSelected(true);
        }
    }

    private void pageInit() {
        this.createActions();
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createPreferencesPanel(), "Center");
    }

    private void createActions() {
        this.selectDefaultTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.default")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.selectDefaultTempDirectory();
            }
        };
        this.selectCustomTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.custom")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.selectCustomTempDirectory();
            }
        };
        this.chooseTempDirectoryAction = new AbstractAction(I18n.getMessage("jsite.preferences.temp-directory.choose")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesPage.this.chooseTempDirectory();
            }
        };
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                PreferencesPage.this.selectDefaultTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.default"));
                PreferencesPage.this.selectCustomTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.custom"));
                PreferencesPage.this.chooseTempDirectoryAction.putValue("Name", I18n.getMessage("jsite.preferences.temp-directory.choose"));
            }
        });
    }

    private JPanel createPreferencesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.preferences.temp-directory") + "</b></html>");
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.defaultTempDirectory = new JRadioButton(this.selectDefaultTempDirectoryAction);
        jPanel2.add((Component)this.defaultTempDirectory, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 21, 1, new Insets(6, 18, 0, 0), 0, 0));
        this.customTempDirectory = new JRadioButton(this.selectCustomTempDirectoryAction);
        jPanel2.add((Component)this.customTempDirectory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 18, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.defaultTempDirectory.getModel().setGroup(buttonGroup);
        this.customTempDirectory.getModel().setGroup(buttonGroup);
        this.tempDirectoryTextField = new JTextField();
        this.tempDirectoryTextField.setEditable(false);
        if (this.tempDirectory != null) {
            this.tempDirectoryTextField.setText(this.tempDirectory);
            this.customTempDirectory.setSelected(true);
        } else {
            this.defaultTempDirectory.setSelected(true);
        }
        this.chooseTempDirectoryAction.setEnabled(this.tempDirectory != null);
        jPanel2.add((Component)this.tempDirectoryTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 1, new Insets(0, 6, 0, 0), 0, 0));
        JButton jButton = new JButton(this.chooseTempDirectoryAction);
        jPanel2.add((Component)jButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 22, 1, new Insets(0, 6, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.preferences.temp-directory") + "</b></html>");
            }
        });
        return jPanel;
    }

    private void selectDefaultTempDirectory() {
        this.tempDirectoryTextField.setEnabled(false);
        this.chooseTempDirectoryAction.setEnabled(false);
        this.tempDirectory = null;
    }

    private void selectCustomTempDirectory() {
        this.tempDirectoryTextField.setEnabled(true);
        this.chooseTempDirectoryAction.setEnabled(true);
        if (this.tempDirectoryTextField.getText().length() == 0) {
            this.chooseTempDirectory();
            if (this.tempDirectoryTextField.getText().length() == 0) {
                this.defaultTempDirectory.setSelected(true);
            }
        }
    }

    private void chooseTempDirectory() {
        JFileChooser jFileChooser = new JFileChooser(this.tempDirectory);
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showDialog(this.wizard, I18n.getMessage("jsite.preferences.temp-directory.choose.approve"));
        if (n == 1) {
            return;
        }
        this.tempDirectory = jFileChooser.getSelectedFile().getPath();
        this.tempDirectoryTextField.setText(this.tempDirectory);
    }
}

