/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.ClientPutDir;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.DiskFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import de.todesbaum.util.io.Closer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class ClientPutComplexDir
extends ClientPutDir {
    private List<FileEntry> fileEntries = new ArrayList<FileEntry>();
    private boolean hasPayload = false;
    private File payloadFile;
    private long payloadLength = 0L;
    private final String tempDirectory;

    public ClientPutComplexDir(String string, String string2) {
        this(string, string2, null);
    }

    public ClientPutComplexDir(String string, String string2, String string3) {
        super("ClientPutComplexDir", string, string2);
        this.tempDirectory = string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addFileEntry(FileEntry fileEntry) {
        block8: {
            block9: {
                if (!(fileEntry instanceof DirectFileEntry)) break block9;
                if (this.payloadFile == null) {
                    try {
                        this.payloadFile = File.createTempFile("payload", ".dat", this.tempDirectory != null ? new File(this.tempDirectory) : null);
                        this.payloadFile.deleteOnExit();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.payloadFile == null) break block8;
                InputStream inputStream = ((DirectFileEntry)fileEntry).getDataInputStream();
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(this.payloadFile, true);
                    byte[] byArray = new byte[65536];
                    int n = 0;
                    while ((n = inputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n);
                    }
                    fileOutputStream.flush();
                    this.fileEntries.add(fileEntry);
                }
                catch (IOException iOException) {
                    Closer.close(fileOutputStream);
                    Closer.close(inputStream);
                    break block8;
                    catch (Throwable throwable) {
                        Closer.close(fileOutputStream);
                        Closer.close(inputStream);
                        throw throwable;
                    }
                }
                Closer.close(fileOutputStream);
                Closer.close(inputStream);
                break block8;
            }
            this.fileEntries.add(fileEntry);
        }
    }

    @Override
    protected void write(Writer writer) throws IOException {
        super.write(writer);
        int n = 0;
        for (FileEntry fileEntry : this.fileEntries) {
            writer.write("Files." + n + ".Name=" + fileEntry.getFilename() + "\r\n");
            if (fileEntry.getContentType() != null) {
                writer.write("Files." + n + ".Metadata.ContentType=" + fileEntry.getContentType() + "\r\n");
            }
            writer.write("Files." + n + ".UploadFrom=" + fileEntry.getName() + "\r\n");
            if (fileEntry instanceof DirectFileEntry) {
                this.hasPayload = true;
                writer.write("Files." + n + ".DataLength=" + ((DirectFileEntry)fileEntry).getDataLength() + "\r\n");
                this.payloadLength += ((DirectFileEntry)fileEntry).getDataLength();
            } else if (fileEntry instanceof DiskFileEntry) {
                writer.write("Files." + n + ".Filename=" + ((DiskFileEntry)fileEntry).getFilename() + "\r\n");
            } else if (fileEntry instanceof RedirectFileEntry) {
                writer.write("Files." + n + ".TargetURI=" + ((RedirectFileEntry)fileEntry).getTargetURI() + "\r\n");
            }
            ++n;
        }
    }

    @Override
    protected boolean hasPayload() {
        return this.hasPayload;
    }

    @Override
    protected long getPayloadLength() {
        return this.payloadLength;
    }

    @Override
    protected InputStream getPayload() {
        if (this.payloadFile != null) {
            try {
                return new FileInputStream(this.payloadFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }
}

