/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SimpleXML {
    private List<SimpleXML> children = new ArrayList<SimpleXML>();
    private String name = null;
    private String value = null;

    public SimpleXML() {
    }

    public SimpleXML(String string) {
        this.name = string;
    }

    public SimpleXML getNode(String string) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get((int)i).name.equals(string)) continue;
            return this.children.get(i);
        }
        return null;
    }

    public SimpleXML getNode(String[] stringArray) {
        SimpleXML simpleXML = this;
        for (String string : stringArray) {
            simpleXML = simpleXML.getNode(string);
        }
        return simpleXML;
    }

    public SimpleXML[] getNodes() {
        return this.getNodes(null);
    }

    public SimpleXML[] getNodes(String string) {
        ArrayList<SimpleXML> arrayList = new ArrayList<SimpleXML>();
        for (SimpleXML simpleXML : this.children) {
            if (string != null && !simpleXML.name.equals(string)) continue;
            arrayList.add(simpleXML);
        }
        return arrayList.toArray(new SimpleXML[arrayList.size()]);
    }

    public SimpleXML append(String string) {
        return this.append(new SimpleXML(string));
    }

    public SimpleXML append(String string, String string2) {
        return this.append(string).setValue(string2);
    }

    public SimpleXML append(SimpleXML simpleXML) {
        this.children.add(simpleXML);
        return simpleXML;
    }

    public void remove(SimpleXML simpleXML) {
        this.children.remove(simpleXML);
    }

    public void remove(String string) {
        SimpleXML simpleXML = this.getNode(string);
        if (simpleXML != null) {
            this.remove(simpleXML);
        }
    }

    public void replace(String string, String string2) {
        this.remove(string);
        this.append(string, string2);
    }

    public void replace(SimpleXML simpleXML) {
        this.remove(simpleXML.getName());
        this.append(simpleXML);
    }

    public void removeAll() {
        this.children.clear();
    }

    public SimpleXML setValue(String string) {
        this.value = string;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String string) {
        return this.value == null ? string : this.value;
    }

    public Document getDocument() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(this.name);
            document.appendChild(element);
            this.addChildren(element);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    private void addChildren(Element element) {
        for (SimpleXML simpleXML : this.children) {
            Element element2 = element.getOwnerDocument().createElement(simpleXML.name);
            element.appendChild(element2);
            if (simpleXML.value != null) {
                Text text = element.getOwnerDocument().createTextNode(simpleXML.value);
                element2.appendChild(text);
                continue;
            }
            simpleXML.addChildren(element2);
        }
    }

    public static SimpleXML fromDocument(Document document) {
        SimpleXML simpleXML = new SimpleXML(document.getFirstChild().getNodeName());
        document.normalizeDocument();
        return SimpleXML.addDocumentChildren(simpleXML, document.getFirstChild());
    }

    private static SimpleXML addDocumentChildren(SimpleXML simpleXML, Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getChildNodes().getLength() == 1 && node2.getFirstChild().getNodeName().equals("#text")) {
                simpleXML.append(node2.getNodeName(), node2.getFirstChild().getNodeValue());
                continue;
            }
            if (node2.getNodeName().equals("#text") && node2.getChildNodes().getLength() == 0) continue;
            SimpleXML simpleXML2 = simpleXML.append(node2.getNodeName());
            SimpleXML.addDocumentChildren(simpleXML2, node2);
        }
        return simpleXML;
    }
}

