/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.application.UpdateChecker;
import de.todesbaum.jsite.application.UpdateListener;
import de.todesbaum.jsite.gui.NodeManagerListener;
import de.todesbaum.jsite.gui.NodeManagerPage;
import de.todesbaum.jsite.gui.PreferencesPage;
import de.todesbaum.jsite.gui.ProjectFilesPage;
import de.todesbaum.jsite.gui.ProjectInsertPage;
import de.todesbaum.jsite.gui.ProjectPage;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.jsite.main.Configuration;
import de.todesbaum.jsite.main.Version;
import de.todesbaum.util.image.IconLoader;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import de.todesbaum.util.swing.WizardListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Main
implements ActionListener,
ListSelectionListener,
WizardListener,
NodeManagerListener,
UpdateListener {
    private static final Logger logger = Logger.getLogger(Main.class.getName());
    private static final Version VERSION = new Version(0, 9);
    private Configuration configuration;
    private Freenet7Interface freenetInterface = new Freenet7Interface();
    private final UpdateChecker updateChecker;
    private Icon jSiteIcon;
    private static final Locale[] SUPPORTED_LOCALES = new Locale[]{Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH};
    private Map<Locale, Action> languageActions = new HashMap<Locale, Action>();
    private Action manageNodeAction;
    private Action optionsPreferencesAction;
    private Action checkForUpdatesAction;
    private Action aboutAction;
    private TWizard wizard;
    private JMenu nodeMenu;
    private Node selectedNode;
    private final Map<PageType, TWizardPage> pages = new HashMap<PageType, TWizardPage>();

    private Main() {
        this(null);
    }

    private Main(String string) {
        this.configuration = string != null ? new Configuration(string) : new Configuration();
        Locale.setDefault(this.configuration.getLocale());
        I18n.setLocale(this.configuration.getLocale());
        if (!this.configuration.createLockFile()) {
            int n = JOptionPane.showOptionDialog(null, I18n.getMessage("jsite.main.already-running"), "", 0, 3, null, new Object[]{I18n.getMessage("jsite.main.already-running.override"), I18n.getMessage("jsite.wizard.quit")}, I18n.getMessage("jsite.wizard.quit"));
            if (n != 0) {
                throw new IllegalStateException("Lockfile override not active, refusing start.");
            }
            this.configuration.removeLockfileOnExit();
        }
        this.wizard = new TWizard();
        this.createActions();
        this.wizard.setJMenuBar(this.createMenuBar());
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setNextEnabled(true);
        this.wizard.addWizardListener(this);
        this.jSiteIcon = IconLoader.loadIcon("/jsite-icon.png");
        this.wizard.setIcon(this.jSiteIcon);
        this.updateChecker = new UpdateChecker(this.freenetInterface);
        this.updateChecker.addUpdateListener(this);
        this.updateChecker.start();
        this.initPages();
        this.showPage(PageType.PAGE_PROJECTS);
    }

    private void createActions() {
        for (final Locale locale : SUPPORTED_LOCALES) {
            this.languageActions.put(locale, new AbstractAction(I18n.getMessage("jsite.menu.language." + locale.getLanguage()), IconLoader.loadIcon("/flag-" + locale.getLanguage() + ".png")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Main.this.switchLanguage(locale);
                }
            });
        }
        this.manageNodeAction = new AbstractAction(I18n.getMessage("jsite.menu.nodes.manage-nodes")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.showPage(PageType.PAGE_NODE_MANAGER);
                Main.this.optionsPreferencesAction.setEnabled(true);
                Main.this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
                Main.this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
            }
        };
        this.optionsPreferencesAction = new AbstractAction(I18n.getMessage("jsite.menu.options.preferences")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.optionsPreferences();
            }
        };
        this.checkForUpdatesAction = new AbstractAction(I18n.getMessage("jsite.menu.help.check-for-updates")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.showLatestUpdate();
            }
        };
        this.aboutAction = new AbstractAction(I18n.getMessage("jsite.menu.help.about")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(Main.this.wizard, MessageFormat.format(I18n.getMessage("jsite.about.message"), Main.getVersion().toString()), null, 1, Main.this.jSiteIcon);
            }
        };
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                Main.this.manageNodeAction.putValue("Name", I18n.getMessage("jsite.menu.nodes.manage-nodes"));
                Main.this.optionsPreferencesAction.putValue("Name", I18n.getMessage("jsite.menu.options.preferences"));
                Main.this.checkForUpdatesAction.putValue("Name", I18n.getMessage("jsite.menu.help.check-for-updates"));
                Main.this.aboutAction.putValue("Name", I18n.getMessage("jsite.menu.help.about"));
            }
        });
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        final JMenu jMenu = new JMenu(I18n.getMessage("jsite.menu.languages"));
        jMenuBar.add(jMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (Locale locale : SUPPORTED_LOCALES) {
            Action action = this.languageActions.get(locale);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(this.languageActions.get(locale));
            if (locale.equals(Locale.getDefault())) {
                jRadioButtonMenuItem.setSelected(true);
            }
            action.putValue("menuItem", jRadioButtonMenuItem);
            buttonGroup.add(jRadioButtonMenuItem);
            jMenu.add(jRadioButtonMenuItem);
        }
        this.nodeMenu = new JMenu(I18n.getMessage("jsite.menu.nodes"));
        jMenuBar.add(this.nodeMenu);
        this.selectedNode = this.configuration.getSelectedNode();
        this.nodesUpdated(this.configuration.getNodes());
        final JMenu jMenu2 = new JMenu(I18n.getMessage("jsite.menu.options"));
        jMenuBar.add(jMenu2);
        jMenu2.add(this.optionsPreferencesAction);
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jMenuBar.add(jPanel);
        final JMenu jMenu3 = new JMenu(I18n.getMessage("jsite.menu.help"));
        jMenuBar.add(jMenu3);
        jMenu3.add(this.checkForUpdatesAction);
        jMenu3.add(this.aboutAction);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jMenu.setText(I18n.getMessage("jsite.menu.languages"));
                Main.this.nodeMenu.setText(I18n.getMessage("jsite.menu.nodes"));
                jMenu2.setText(I18n.getMessage("jsite.menu.options"));
                jMenu3.setText(I18n.getMessage("jsite.menu.help"));
                for (Map.Entry entry : Main.this.languageActions.entrySet()) {
                    ((Action)entry.getValue()).putValue("Name", I18n.getMessage("jsite.menu.language." + ((Locale)entry.getKey()).getLanguage()));
                }
            }
        });
        return jMenuBar;
    }

    private void initPages() {
        NodeManagerPage nodeManagerPage = new NodeManagerPage(this.wizard);
        nodeManagerPage.setName("page.node-manager");
        nodeManagerPage.addNodeManagerListener(this);
        nodeManagerPage.setNodes(this.configuration.getNodes());
        this.pages.put(PageType.PAGE_NODE_MANAGER, nodeManagerPage);
        ProjectPage projectPage = new ProjectPage(this.wizard);
        projectPage.setName("page.project");
        projectPage.setProjects(this.configuration.getProjects());
        projectPage.setFreenetInterface(this.freenetInterface);
        projectPage.addListSelectionListener(this);
        this.pages.put(PageType.PAGE_PROJECTS, projectPage);
        ProjectFilesPage projectFilesPage = new ProjectFilesPage(this.wizard);
        projectFilesPage.setName("page.project.files");
        this.pages.put(PageType.PAGE_PROJECT_FILES, projectFilesPage);
        ProjectInsertPage projectInsertPage = new ProjectInsertPage(this.wizard);
        projectInsertPage.setName("page.project.insert");
        projectInsertPage.setFreenetInterface(this.freenetInterface);
        this.pages.put(PageType.PAGE_INSERT_PROJECT, projectInsertPage);
        PreferencesPage preferencesPage = new PreferencesPage(this.wizard);
        preferencesPage.setName("page.preferences");
        preferencesPage.setTempDirectory(this.configuration.getTempDirectory());
        this.pages.put(PageType.PAGE_PREFERENCES, preferencesPage);
    }

    private void showPage(PageType pageType) {
        this.wizard.setPreviousEnabled(pageType.ordinal() > 0);
        this.wizard.setNextEnabled(pageType.ordinal() < this.pages.size() - 1);
        this.wizard.setPage(this.pages.get((Object)pageType));
        this.wizard.setTitle(this.pages.get((Object)pageType).getHeading() + " - jSite");
    }

    private boolean saveConfiguration() {
        NodeManagerPage nodeManagerPage = (NodeManagerPage)this.pages.get((Object)PageType.PAGE_NODE_MANAGER);
        this.configuration.setNodes(nodeManagerPage.getNodes());
        if (this.selectedNode != null) {
            this.configuration.setSelectedNode(this.selectedNode);
        }
        ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
        this.configuration.setProjects(projectPage.getProjects());
        PreferencesPage preferencesPage = (PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES);
        this.configuration.setTempDirectory(preferencesPage.getTempDirectory());
        return this.configuration.save();
    }

    private Locale findSupportedLocale(Locale locale) {
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.equals(locale)) continue;
            return locale2;
        }
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.getCountry().equals(locale.getCountry()) || !locale2.getLanguage().equals(locale.getLanguage())) continue;
            return locale2;
        }
        for (Locale locale2 : SUPPORTED_LOCALES) {
            if (!locale2.getLanguage().equals(locale.getLanguage())) continue;
            return locale2;
        }
        return SUPPORTED_LOCALES[0];
    }

    public static final Version getVersion() {
        return VERSION;
    }

    private void switchLanguage(Locale locale) {
        Locale locale2 = this.findSupportedLocale(locale);
        Action action = this.languageActions.get(locale2);
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)action.getValue("menuItem");
        jRadioButtonMenuItem.setSelected(true);
        I18n.setLocale(locale2);
        for (Runnable runnable : I18nContainer.getInstance()) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {}
        }
        this.wizard.setPage(this.wizard.getPage());
        this.configuration.setLocale(locale2);
    }

    private void optionsPreferences() {
        this.showPage(PageType.PAGE_PREFERENCES);
        this.optionsPreferencesAction.setEnabled(false);
        this.wizard.setNextEnabled(true);
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
    }

    private void showLatestUpdate() {
        Version version = this.updateChecker.getLatestVersion();
        int n = version.compareTo(VERSION);
        if (n > 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.newer.message"), VERSION, version), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        } else if (n < 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.older.message"), VERSION, version), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        } else {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.latest-version.okay.message"), VERSION, version), I18n.getMessage("jsite.update-checker.latest-version.title"), 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getSelectedIndex();
        this.wizard.setNextEnabled(n > -1);
    }

    @Override
    public void wizardNextPressed(TWizard tWizard) {
        String string = tWizard.getPage().getName();
        if ("page.node-manager".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project".equals(string)) {
            ProjectPage projectPage = (ProjectPage)tWizard.getPage();
            Project project = projectPage.getSelectedProject();
            if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.warning.no-local-path"), null, 0);
                return;
            }
            if (project.getPath() == null || project.getPath().trim().length() == 0) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.warning.no-path"), null, 0);
                return;
            }
            ((ProjectFilesPage)this.pages.get((Object)PageType.PAGE_PROJECT_FILES)).setProject(project);
            ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).setProject(project);
            this.showPage(PageType.PAGE_PROJECT_FILES);
        } else if ("page.project.files".equals(string)) {
            Object object2;
            ProjectPage projectPage = (ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS);
            Project project = projectPage.getSelectedProject();
            if (this.selectedNode == null) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.error.no-node-selected"), null, 0);
                return;
            }
            ProjectInserter.CheckReport checkReport = ProjectInserter.validateProject(project);
            for (Object object2 : checkReport) {
                if (((ProjectInserter.Issue)object2).isFatal()) {
                    JOptionPane.showMessageDialog(tWizard, MessageFormat.format(I18n.getMessage("jsite." + ((ProjectInserter.Issue)object2).getErrorKey()), ((ProjectInserter.Issue)object2).getParameters()), null, 0);
                    return;
                }
                if (JOptionPane.showConfirmDialog(tWizard, MessageFormat.format(I18n.getMessage("jsite." + ((ProjectInserter.Issue)object2).getErrorKey()), ((ProjectInserter.Issue)object2).getParameters()), null, 2, 2) == 0) continue;
                return;
            }
            boolean bl = false;
            try {
                bl = this.freenetInterface.isNodePresent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!bl) {
                JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.error.no-node-running"), null, 0);
                return;
            }
            this.configuration.save();
            this.showPage(PageType.PAGE_INSERT_PROJECT);
            object2 = (ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT);
            String string2 = ((PreferencesPage)this.pages.get((Object)PageType.PAGE_PREFERENCES)).getTempDirectory();
            ((ProjectInsertPage)object2).setTempDirectory(string2);
            ((ProjectInsertPage)object2).startInsert();
            this.nodeMenu.setEnabled(false);
            this.optionsPreferencesAction.setEnabled(false);
        } else if ("page.project.insert".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
            this.nodeMenu.setEnabled(true);
            this.optionsPreferencesAction.setEnabled(true);
        } else if ("page.preferences".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
            this.optionsPreferencesAction.setEnabled(true);
        }
    }

    @Override
    public void wizardPreviousPressed(TWizard tWizard) {
        String string = tWizard.getPage().getName();
        if ("page.project".equals(string) || "page.preferences".equals(string)) {
            this.showPage(PageType.PAGE_NODE_MANAGER);
            this.optionsPreferencesAction.setEnabled(true);
        } else if ("page.project.files".equals(string)) {
            this.showPage(PageType.PAGE_PROJECTS);
        } else if ("page.project.insert".equals(string)) {
            this.showPage(PageType.PAGE_PROJECT_FILES);
        }
    }

    @Override
    public void wizardQuitPressed(TWizard tWizard) {
        if (((ProjectPage)this.pages.get((Object)PageType.PAGE_PROJECTS)).wasUriCopied() || ((ProjectInsertPage)this.pages.get((Object)PageType.PAGE_INSERT_PROJECT)).wasUriCopied()) {
            JOptionPane.showMessageDialog(tWizard, I18n.getMessage("jsite.project.warning.use-clipboard-now"));
        }
        if (JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.quit.question"), null, 2, 3) == 0) {
            if (this.saveConfiguration()) {
                System.exit(0);
            }
            if (JOptionPane.showConfirmDialog(tWizard, I18n.getMessage("jsite.quit.config-not-saved"), null, 2, 2) == 0) {
                System.exit(0);
            }
        }
    }

    @Override
    public void nodesUpdated(Node[] nodeArray) {
        this.nodeMenu.removeAll();
        ButtonGroup buttonGroup = new ButtonGroup();
        Node node = null;
        for (Node node2 : nodeArray) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(node2.getName());
            jRadioButtonMenuItem.putClientProperty("Node", node2);
            jRadioButtonMenuItem.addActionListener(this);
            buttonGroup.add(jRadioButtonMenuItem);
            if (node2.equals(this.selectedNode)) {
                node = node2;
                jRadioButtonMenuItem.setSelected(true);
            }
            this.nodeMenu.add(jRadioButtonMenuItem);
        }
        this.nodeMenu.addSeparator();
        this.nodeMenu.add(this.manageNodeAction);
        this.selectedNode = node;
        this.freenetInterface.setNode(this.selectedNode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JRadioButtonMenuItem) {
            Node node;
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)object;
            this.selectedNode = node = (Node)jRadioButtonMenuItem.getClientProperty("Node");
            this.freenetInterface.setNode(this.selectedNode);
        }
    }

    @Override
    public void foundUpdateData(Version version, long l) {
        logger.log(Level.FINEST, "Found version {0} from {1,date}.", new Object[]{version, l});
        if (version.compareTo(VERSION) > 0) {
            JOptionPane.showMessageDialog(this.wizard, MessageFormat.format(I18n.getMessage("jsite.update-checker.found-version.message"), version.toString(), new Date(l)), I18n.getMessage("jsite.update-checker.found-version.title"), 1);
        }
    }

    public static void main(String[] stringArray) {
        Logger logger = Logger.getLogger("de.todesbaum");
        ConsoleHandler consoleHandler = new ConsoleHandler();
        logger.addHandler(consoleHandler);
        String string = null;
        boolean bl = false;
        for (String string2 : stringArray) {
            if (bl) {
                string = string2;
                bl = false;
            }
            if ("--help".equals(string2)) {
                Main.printHelp();
                return;
            }
            if ("--debug".equals(string2)) {
                logger.setLevel(Level.ALL);
                consoleHandler.setLevel(Level.ALL);
                continue;
            }
            if (!"--config-file".equals(string2)) continue;
            bl = true;
        }
        if (bl) {
            System.out.println("--config-file needs parameter!");
            return;
        }
        new Main(string);
    }

    private static void printHelp() {
        System.out.println("--help\tshows this cruft");
        System.out.println("--debug\tenables some debug output");
        System.out.println("--config-file <file>\tuse specified configuration file");
    }

    private static enum PageType {
        PAGE_NODE_MANAGER,
        PAGE_PROJECTS,
        PAGE_PROJECT_FILES,
        PAGE_INSERT_PROJECT,
        PAGE_PREFERENCES;

    }
}

