/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class XML {
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transformerFactory = null;

    private XML() {
    }

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        if (documentBuilderFactory != null) {
            return documentBuilderFactory;
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory;
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder != null) {
            return documentBuilder;
        }
        try {
            documentBuilder = XML.getDocumentBuilderFactory().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return documentBuilder;
    }

    private static TransformerFactory getTransformerFactory() {
        if (transformerFactory != null) {
            return transformerFactory;
        }
        transformerFactory = TransformerFactory.newInstance();
        return transformerFactory;
    }

    public static Document createDocument() {
        return XML.getDocumentBuilder().newDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transformToByteArray(Document document) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, Charset.forName("UTF-8"));
        StreamResult streamResult = new StreamResult(outputStreamWriter);
        DOMSource dOMSource = new DOMSource(document);
        try {
            Transformer transformer = XML.getTransformerFactory().newTransformer();
            transformer.transform(dOMSource, streamResult);
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document transformToDocument(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, Charset.forName("UTF-8"));
        StreamSource streamSource = new StreamSource(inputStreamReader);
        DOMResult dOMResult = new DOMResult();
        try {
            Transformer transformer = XML.getTransformerFactory().newTransformer();
            transformer.transform(streamSource, dOMResult);
            Document document = (Document)dOMResult.getNode();
            return document;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (TransformerException transformerException) {
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

