/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.jsite.i18n.I18n;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FileScanner
implements Runnable {
    private final List<FileScannerListener> fileScannerListeners = new ArrayList<FileScannerListener>();
    private final Project project;
    private List<String> files;
    private boolean error = false;

    public FileScanner(Project project) {
        this.project = project;
    }

    public void addFileScannerListener(FileScannerListener fileScannerListener) {
        this.fileScannerListeners.add(fileScannerListener);
    }

    public void removeFileScannerListener(FileScannerListener fileScannerListener) {
        this.fileScannerListeners.remove(fileScannerListener);
    }

    protected void fireFileScannerFinished() {
        for (FileScannerListener fileScannerListener : new ArrayList<FileScannerListener>(this.fileScannerListeners)) {
            fileScannerListener.fileScannerFinished(this);
        }
    }

    @Override
    public void run() {
        this.files = new ArrayList<String>();
        this.error = false;
        try {
            this.scanFiles(new File(this.project.getLocalPath()), this.files);
            Collections.sort(this.files);
        }
        catch (IOException iOException) {
            this.error = true;
        }
        this.fireFileScannerFinished();
    }

    public boolean isError() {
        return this.error;
    }

    public List<String> getFiles() {
        return this.files;
    }

    private void scanFiles(File file, List<String> list) throws IOException {
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !FileScanner.this.project.isIgnoreHiddenFiles() || !file.isHidden();
            }
        });
        if (fileArray == null) {
            throw new IOException(I18n.getMessage("jsite.file-scanner.can-not-read-directory"));
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                this.scanFiles(file2, list);
                continue;
            }
            String string = this.project.shortenFilename(file2);
            string = string.replace('\\', '/');
            list.add(string);
        }
    }
}

