/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.freenet.fcp2;

import de.todesbaum.util.freenet.fcp2.Command;
import de.todesbaum.util.freenet.fcp2.Persistence;
import de.todesbaum.util.freenet.fcp2.PriorityClass;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import java.io.IOException;
import java.io.Writer;

public abstract class ClientPut
extends Command {
    protected final String uri;
    protected String clientToken = null;
    protected boolean getCHKOnly = false;
    protected boolean global = false;
    protected boolean dontCompress = false;
    protected int maxRetries = 0;
    protected boolean earlyEncode = false;
    protected Persistence persistence = Persistence.CONNECTION;
    protected PriorityClass priorityClass = PriorityClass.INTERACTIVE;
    protected Verbosity verbosity = Verbosity.NONE;

    protected ClientPut(String string, String string2, String string3) {
        super(string, string2);
        this.uri = string3;
    }

    public boolean isDontCompress() {
        return this.dontCompress;
    }

    public void setDontCompress(boolean bl) {
        this.dontCompress = bl;
    }

    public boolean isGetCHKOnly() {
        return this.getCHKOnly;
    }

    public void setGetCHKOnly(boolean bl) {
        this.getCHKOnly = bl;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public boolean isEarlyEncode() {
        return this.earlyEncode;
    }

    public void setEarlyEncode(boolean bl) {
        this.earlyEncode = bl;
    }

    public PriorityClass getPriorityClass() {
        return this.priorityClass;
    }

    public void setPriorityClass(PriorityClass priorityClass) {
        this.priorityClass = priorityClass;
    }

    public Verbosity getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(Verbosity verbosity) {
        this.verbosity = verbosity;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    protected void write(Writer writer) throws IOException {
        super.write(writer);
        writer.write("URI=" + this.uri + "\r\n");
        if (this.verbosity != null) {
            writer.write("Verbosity=" + this.verbosity.getValue() + "\r\n");
        }
        if (this.maxRetries != 0) {
            writer.write("MaxRetries=" + this.maxRetries + "\r\n");
        }
        writer.write("EarlyEncode=" + this.earlyEncode);
        if (this.priorityClass != null) {
            writer.write("PriorityClass=" + this.priorityClass.getValue() + "\r\n");
        }
        writer.write("GetCHKOnly=" + this.getCHKOnly + "\r\n");
        writer.write("Global=" + this.global + "\r\n");
        writer.write("DontCompress=" + this.dontCompress + "\r\n");
        if (this.clientToken != null) {
            writer.write("ClientToken=" + this.clientToken + "\r\n");
        }
        if (this.persistence != null) {
            writer.write("Persistence=" + this.persistence.getName() + "\r\n");
        }
    }
}

