/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.util.swing;

import de.todesbaum.util.swing.TWizardPage;
import de.todesbaum.util.swing.WizardListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class TWizard
extends JFrame
implements WindowListener {
    protected List<WizardListener> wizardListeners = new ArrayList<WizardListener>();
    private Action previousAction;
    private Action nextAction;
    private Action quitAction;
    private JLabel pageIcon;
    private JPanel pagePanel;
    private JLabel pageHeading;
    private JLabel pageDescription;

    @Override
    protected void frameInit() {
        super.frameInit();
        this.setResizable(false);
        this.addWindowListener(this);
        this.setDefaultCloseOperation(0);
        this.createActions();
        this.pageIcon = new JLabel();
        this.pageIcon.setVerticalAlignment(1);
        this.pageHeading = new JLabel();
        this.pageHeading.setFont(this.pageHeading.getFont().deriveFont((float)this.pageHeading.getFont().getSize() * 2.0f).deriveFont(1));
        this.pageDescription = new JLabel();
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        JPanel jPanel2 = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)jPanel2, "First");
        jPanel2.add((Component)this.pageIcon, "Before");
        JPanel jPanel3 = new JPanel(new BorderLayout(12, 12));
        jPanel2.add((Component)jPanel3, "Center");
        jPanel3.add((Component)this.pageHeading, "First");
        jPanel3.add((Component)this.pageDescription, "Center");
        this.pagePanel = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)this.pagePanel, "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(4, 12, 12));
        jPanel4.setBorder(new EmptyBorder(-12, -12, -12, -12));
        jPanel4.add(new JButton(this.previousAction));
        jPanel4.add(new JButton(this.nextAction));
        jPanel4.add(new JButton(this.quitAction));
        jPanel.add((Component)jPanel4, "Last");
        this.setContentPane(jPanel);
    }

    @Override
    public void pack() {
        super.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    private void createActions() {
        this.previousAction = new AbstractAction("Previous"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionPrevious();
            }
        };
        this.nextAction = new AbstractAction("Next"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionNext();
            }
        };
        this.quitAction = new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TWizard.this.actionQuit();
            }
        };
    }

    public void addWizardListener(WizardListener wizardListener) {
        this.wizardListeners.add(wizardListener);
    }

    public void removeWizardListener(WizardListener wizardListener) {
        this.wizardListeners.remove(wizardListener);
    }

    protected void fireWizardPreviousPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardPreviousPressed(this);
        }
    }

    protected void fireWizardNextPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardNextPressed(this);
        }
    }

    protected void fireWizardQuitPressed() {
        for (WizardListener wizardListener : this.wizardListeners) {
            wizardListener.wizardQuitPressed(this);
        }
    }

    public void setIcon(Icon icon) {
        this.pageIcon.setIcon(icon);
    }

    public void setPage(TWizardPage tWizardPage) {
        this.setVisible(false);
        this.pageHeading.setText(tWizardPage.getHeading());
        this.pageDescription.setText(tWizardPage.getDescription());
        if (this.pagePanel.getComponentCount() > 0 && this.pagePanel.getComponent(0) instanceof TWizardPage) {
            ((TWizardPage)this.pagePanel.getComponent(0)).pageDeleted(this);
        }
        this.pagePanel.removeAll();
        this.pagePanel.add((Component)tWizardPage, "Center");
        tWizardPage.pageAdded(this);
        this.pack();
        this.setTitle(tWizardPage.getHeading());
        this.setVisible(true);
    }

    public TWizardPage getPage() {
        return (TWizardPage)this.pagePanel.getComponent(0);
    }

    public void setPreviousEnabled(boolean bl) {
        this.previousAction.setEnabled(bl);
    }

    public void setPreviousName(String string) {
        this.previousAction.putValue("Name", string);
    }

    public void setNextEnabled(boolean bl) {
        this.nextAction.setEnabled(bl);
    }

    public void setNextName(String string) {
        this.nextAction.putValue("Name", string);
    }

    public void setQuitEnabled(boolean bl) {
        this.quitAction.setEnabled(bl);
    }

    public void setQuitName(String string) {
        this.quitAction.putValue("Name", string);
    }

    protected void actionPrevious() {
        this.fireWizardPreviousPressed();
    }

    protected void actionNext() {
        this.fireWizardNextPressed();
    }

    protected void actionQuit() {
        this.fireWizardQuitPressed();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.fireWizardQuitPressed();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

