/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class KeyDialog
extends JDialog {
    private final Freenet7Interface freenetInterface;
    private String publicKey;
    private String privateKey;
    private Action okAction;
    private Action cancelAction;
    private Action generateAction;
    private JTextField privateKeyTextField;
    private JTextField publicKeyTextField;
    private boolean cancelled;

    public KeyDialog(Freenet7Interface freenet7Interface, JFrame jFrame) {
        super(jFrame, I18n.getMessage("jsite.key-dialog.title"), true);
        this.freenetInterface = freenet7Interface;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                KeyDialog.this.actionCancel();
            }
        });
        this.initDialog();
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String string) {
        this.publicKey = string;
        this.publicKeyTextField.setText(string);
        this.pack();
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String string) {
        this.privateKey = string;
        this.privateKeyTextField.setText(string);
        this.pack();
    }

    @Override
    public void pack() {
        super.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
    }

    private void createActions() {
        this.okAction = new AbstractAction(I18n.getMessage("jsite.general.ok")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionOk();
            }
        };
        this.okAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.ok.tooltip"));
        this.okAction.putValue("MnemonicKey", 10);
        this.cancelAction = new AbstractAction(I18n.getMessage("jsite.general.cancel")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionCancel();
            }
        };
        this.cancelAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.cancel.tooltip"));
        this.cancelAction.putValue("MnemonicKey", 27);
        this.generateAction = new AbstractAction(I18n.getMessage("jsite.key-dialog.button.generate")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyDialog.this.actionGenerate();
            }
        };
        this.generateAction.putValue("ShortDescription", I18n.getMessage("jsite.key-dialog.button.generate.tooltip"));
        this.generateAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 128));
    }

    private void initDialog() {
        this.createActions();
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, "Center");
        final JLabel jLabel = new JLabel(I18n.getMessage("jsite.key-dialog.label.keys"));
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel jLabel2 = new JLabel(I18n.getMessage("jsite.key-dialog.label.private-key"));
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 18, 0, 0), 0, 0));
        this.privateKeyTextField = new JTextField();
        jPanel2.add((Component)this.privateKeyTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel jLabel3 = new JLabel(I18n.getMessage("jsite.key-dialog.label.public-key"));
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        this.publicKeyTextField = new JTextField();
        jPanel2.add((Component)this.publicKeyTextField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 12, 0, 0), 0, 0));
        final JLabel jLabel4 = new JLabel(I18n.getMessage("jsite.key-dialog.label.actions"));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(12, 0, 0, 0), 0, 0));
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 12, 12));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(-12, -12, -12, -12));
        jPanel2.add((Component)jPanel3, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 21, 0, new Insets(12, 18, 0, 0), 0, 0));
        jPanel3.add(new JButton(this.generateAction));
        JPanel jPanel4 = new JPanel(new BorderLayout(12, 12));
        jPanel.add((Component)jPanel4, "Last");
        jPanel4.add((Component)new JSeparator(0), "First");
        JPanel jPanel5 = new JPanel(new FlowLayout(4, 12, 12));
        jPanel5.setBorder(BorderFactory.createEmptyBorder(-12, -12, -12, -12));
        jPanel4.add((Component)jPanel5, "Center");
        jPanel5.add(new JButton(this.okAction));
        jPanel5.add(new JButton(this.cancelAction));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText(I18n.getMessage("jsite.key-dialog.label.keys"));
                jLabel2.setText(I18n.getMessage("jsite.key-dialog.label.private-key"));
                jLabel3.setText(I18n.getMessage("jsite.key-dialog.label.public-key"));
                jLabel4.setText(I18n.getMessage("jsite.key-dialog.label.actions"));
            }
        });
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    private void actionOk() {
        this.publicKey = this.publicKeyTextField.getText();
        this.privateKey = this.privateKeyTextField.getText();
        this.cancelled = false;
        this.setVisible(false);
    }

    private void actionCancel() {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void actionGenerate() {
        if (JOptionPane.showConfirmDialog(this, I18n.getMessage("jsite.project.warning.generate-new-key"), null, 2) == 2) {
            return;
        }
        String[] stringArray = null;
        try {
            stringArray = this.freenetInterface.generateKeyPair();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(I18n.getMessage("jsite.project.keygen.io-error"), iOException.getMessage()), null, 0);
            return;
        }
        this.publicKeyTextField.setText(stringArray[1].substring(stringArray[1].indexOf(64) + 1, stringArray[1].lastIndexOf(47)));
        this.privateKeyTextField.setText(stringArray[0].substring(stringArray[0].indexOf(64) + 1, stringArray[0].lastIndexOf(47)));
        this.pack();
    }
}

