/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.KeyDialog;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.SortedListModel;
import de.todesbaum.util.swing.TLabel;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class ProjectPage
extends TWizardPage
implements ListSelectionListener,
DocumentListener,
ClipboardOwner {
    private Freenet7Interface freenetInterface;
    private Action projectLocalPathBrowseAction;
    private Action projectAddAction;
    private Action projectDeleteAction;
    private Action projectCloneAction;
    private Action projectManageKeysAction;
    private Action projectCopyURIAction;
    private Action projectResetEditionAction;
    private JFileChooser pathChooser;
    private SortedListModel<Project> projectListModel;
    private JScrollPane projectScrollPane;
    private JList projectList;
    private JTextField projectNameTextField;
    private JTextField projectDescriptionTextField;
    private JTextField projectLocalPathTextField;
    private JTextField projectCompleteUriTextField;
    private JTextField projectPathTextField;
    private boolean uriCopied;

    public ProjectPage(TWizard tWizard) {
        super(tWizard);
        this.setLayout(new BorderLayout(12, 12));
        this.dialogInit();
        this.setHeading(I18n.getMessage("jsite.project.heading"));
        this.setDescription(I18n.getMessage("jsite.project.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectPage.this.setHeading(I18n.getMessage("jsite.project.heading"));
                ProjectPage.this.setDescription(I18n.getMessage("jsite.project.description"));
            }
        });
    }

    private void dialogInit() {
        this.createActions();
        this.pathChooser = new JFileChooser();
        this.projectListModel = new SortedListModel();
        this.projectList = new JList<Project>(this.projectListModel);
        this.projectList.setSelectionMode(0);
        this.projectList.addListSelectionListener(this);
        this.projectScrollPane = new JScrollPane(this.projectList);
        this.add((Component)this.projectScrollPane, "Before");
        this.projectScrollPane.setPreferredSize(new Dimension(150, this.projectList.getPreferredSize().height));
        this.add((Component)this.createInformationPanel(), "Center");
    }

    @Override
    public void pageAdded(TWizard tWizard) {
        super.pageAdded(tWizard);
        this.projectList.clearSelection();
        this.wizard.setPreviousName(I18n.getMessage("jsite.menu.nodes.manage-nodes"));
        this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
        this.wizard.setNextEnabled(false);
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.projectList.addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.projectList.removeListSelectionListener(listSelectionListener);
    }

    private void createActions() {
        this.projectLocalPathBrowseAction = new AbstractAction(I18n.getMessage("jsite.project.action.browse")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionLocalPathBrowse();
            }
        };
        this.projectLocalPathBrowseAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.browse.tooltip"));
        this.projectLocalPathBrowseAction.putValue("MnemonicKey", 66);
        this.projectLocalPathBrowseAction.setEnabled(false);
        this.projectAddAction = new AbstractAction(I18n.getMessage("jsite.project.action.add-project")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionAdd();
            }
        };
        this.projectAddAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.add-project.tooltip"));
        this.projectAddAction.putValue("MnemonicKey", 65);
        this.projectDeleteAction = new AbstractAction(I18n.getMessage("jsite.project.action.delete-project")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionDelete();
            }
        };
        this.projectDeleteAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.delete-project.tooltip"));
        this.projectDeleteAction.putValue("MnemonicKey", 68);
        this.projectDeleteAction.setEnabled(false);
        this.projectCloneAction = new AbstractAction(I18n.getMessage("jsite.project.action.clone-project")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionClone();
            }
        };
        this.projectCloneAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.clone-project.tooltip"));
        this.projectCloneAction.putValue("MnemonicKey", 76);
        this.projectCloneAction.setEnabled(false);
        this.projectCopyURIAction = new AbstractAction(I18n.getMessage("jsite.project.action.copy-uri")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionCopyURI();
            }
        };
        this.projectCopyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
        this.projectCopyURIAction.putValue("MnemonicKey", 85);
        this.projectCopyURIAction.setEnabled(false);
        this.projectManageKeysAction = new AbstractAction(I18n.getMessage("jsite.project.action.manage-keys")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionManageKeys();
            }
        };
        this.projectManageKeysAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.manage-keys.tooltip"));
        this.projectManageKeysAction.putValue("MnemonicKey", 77);
        this.projectManageKeysAction.setEnabled(false);
        this.projectResetEditionAction = new AbstractAction(I18n.getMessage("jsite.project.action.reset-edition")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectPage.this.actionResetEdition();
            }
        };
        this.projectResetEditionAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.reset-edition.tooltip"));
        this.projectResetEditionAction.putValue("MnemonicKey", 82);
        this.projectResetEditionAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectPage.this.projectLocalPathBrowseAction.putValue("Name", I18n.getMessage("jsite.project.action.browse"));
                ProjectPage.this.projectLocalPathBrowseAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.browse.tooltip"));
                ProjectPage.this.projectAddAction.putValue("Name", I18n.getMessage("jsite.project.action.add-project"));
                ProjectPage.this.projectAddAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.add-project.tooltip"));
                ProjectPage.this.projectDeleteAction.putValue("Name", I18n.getMessage("jsite.project.action.delete-project"));
                ProjectPage.this.projectDeleteAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.delete-project.tooltip"));
                ProjectPage.this.projectCloneAction.putValue("Name", I18n.getMessage("jsite.project.action.clone-project"));
                ProjectPage.this.projectCloneAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.clone-project.tooltip"));
                ProjectPage.this.projectCopyURIAction.putValue("Name", I18n.getMessage("jsite.project.action.copy-uri"));
                ProjectPage.this.projectCopyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
                ProjectPage.this.projectManageKeysAction.putValue("Name", I18n.getMessage("jsite.project.action.manage-keys"));
                ProjectPage.this.projectManageKeysAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.manage-keys.tooltip"));
                ProjectPage.this.projectResetEditionAction.putValue("Name", I18n.getMessage("jsite.project.action.reset-edition"));
                ProjectPage.this.projectResetEditionAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.reset-edition.tooltip"));
                ProjectPage.this.pathChooser.setApproveButtonText(I18n.getMessage("jsite.project.action.browse.choose"));
            }
        });
    }

    private JComponent createInformationPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new FlowLayout(3, 12, 12));
        jPanel3.setBorder(new EmptyBorder(-12, -12, -12, -12));
        jPanel3.add(new JButton(this.projectAddAction));
        jPanel3.add(new JButton(this.projectDeleteAction));
        jPanel3.add(new JButton(this.projectCloneAction));
        jPanel3.add(new JButton(this.projectManageKeysAction));
        jPanel.add((Component)jPanel3, "First");
        jPanel.add((Component)jPanel2, "Center");
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.project.project.information") + "</b></html>");
        jPanel2.add((Component)jLabel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.projectNameTextField = new JTextField();
        this.projectNameTextField.getDocument().putProperty("name", "project.name");
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectNameTextField.setEnabled(false);
        final TLabel tLabel = new TLabel(I18n.getMessage("jsite.project.project.name") + ":", 78, (Component)this.projectNameTextField);
        jPanel2.add((Component)tLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel2.add((Component)this.projectNameTextField, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.projectDescriptionTextField = new JTextField();
        this.projectDescriptionTextField.getDocument().putProperty("name", "project.description");
        this.projectDescriptionTextField.getDocument().addDocumentListener(this);
        this.projectDescriptionTextField.setEnabled(false);
        final TLabel tLabel2 = new TLabel(I18n.getMessage("jsite.project.project.description") + ":", 68, (Component)this.projectDescriptionTextField);
        jPanel2.add((Component)tLabel2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel2.add((Component)this.projectDescriptionTextField, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.projectLocalPathTextField = new JTextField();
        this.projectLocalPathTextField.getDocument().putProperty("name", "project.localpath");
        this.projectLocalPathTextField.getDocument().addDocumentListener(this);
        this.projectLocalPathTextField.setEnabled(false);
        final TLabel tLabel3 = new TLabel(I18n.getMessage("jsite.project.project.local-path") + ":", 76, (Component)this.projectLocalPathTextField);
        jPanel2.add((Component)tLabel3, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel2.add((Component)this.projectLocalPathTextField, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)new JButton(this.projectLocalPathBrowseAction), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        final JLabel jLabel2 = new JLabel("<html><b>" + I18n.getMessage("jsite.project.project.address") + "</b></html>");
        jPanel2.add((Component)jLabel2, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 21, 0, new Insets(12, 0, 0, 0), 0, 0));
        this.projectPathTextField = new JTextField();
        this.projectPathTextField.getDocument().putProperty("name", "project.path");
        this.projectPathTextField.getDocument().addDocumentListener(this);
        ((AbstractDocument)this.projectPathTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int n, String string, AttributeSet attributeSet) throws BadLocationException {
                super.insertString(filterBypass, n, string.replaceAll("/", ""), attributeSet);
                ProjectPage.this.updateCompleteURI();
            }

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                super.replace(filterBypass, n, n2, string.replaceAll("/", ""), attributeSet);
                ProjectPage.this.updateCompleteURI();
            }

            @Override
            public void remove(DocumentFilter.FilterBypass filterBypass, int n, int n2) throws BadLocationException {
                super.remove(filterBypass, n, n2);
                ProjectPage.this.updateCompleteURI();
            }
        });
        this.projectPathTextField.setEnabled(false);
        final TLabel tLabel4 = new TLabel(I18n.getMessage("jsite.project.project.path") + ":", 80, (Component)this.projectPathTextField);
        jPanel2.add((Component)tLabel4, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel2.add((Component)this.projectPathTextField, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        this.projectCompleteUriTextField = new JTextField();
        this.projectCompleteUriTextField.setEditable(false);
        final TLabel tLabel5 = new TLabel(I18n.getMessage("jsite.project.project.uri") + ":", 85, (Component)this.projectCompleteUriTextField);
        jPanel2.add((Component)tLabel5, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 21, 0, new Insets(6, 18, 0, 0), 0, 0));
        jPanel2.add((Component)this.projectCompleteUriTextField, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel2.add((Component)new JButton(this.projectCopyURIAction), new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(6, 6, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.project.project.information") + "</b></html>");
                tLabel.setText(I18n.getMessage("jsite.project.project.name") + ":");
                tLabel2.setText(I18n.getMessage("jsite.project.project.description") + ":");
                tLabel3.setText(I18n.getMessage("jsite.project.project.local-path") + ":");
                jLabel2.setText("<html><b>" + I18n.getMessage("jsite.project.project.address") + "</b></html>");
                tLabel4.setText(I18n.getMessage("jsite.project.project.path") + ":");
                tLabel5.setText(I18n.getMessage("jsite.project.project.uri") + ":");
            }
        });
        return jPanel;
    }

    public void setProjects(Project[] projectArray) {
        this.projectListModel.clear();
        for (Project project : projectArray) {
            this.projectListModel.add(project);
        }
    }

    public Project[] getProjects() {
        return this.projectListModel.toArray((U[])new Project[this.projectListModel.size()]);
    }

    public void setFreenetInterface(Freenet7Interface freenet7Interface) {
        this.freenetInterface = freenet7Interface;
    }

    public Project getSelectedProject() {
        return (Project)this.projectList.getSelectedValue();
    }

    public boolean wasUriCopied() {
        return this.uriCopied;
    }

    private void setTextField(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        String string = (String)document.getProperty("name");
        Project project = (Project)this.projectList.getSelectedValue();
        if (project == null) {
            return;
        }
        try {
            String string2 = document.getText(0, document.getLength()).trim();
            if ("project.name".equals(string)) {
                project.setName(string2);
                this.projectList.repaint();
            } else if ("project.description".equals(string)) {
                project.setDescription(string2);
            } else if ("project.localpath".equals(string)) {
                project.setLocalPath(string2);
            } else if ("project.privatekey".equals(string)) {
                project.setInsertURI(string2);
            } else if ("project.publickey".equals(string)) {
                project.setRequestURI(string2);
            } else if ("project.path".equals(string)) {
                project.setPath(string2);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void actionLocalPathBrowse() {
        Project project = (Project)this.projectList.getSelectedValue();
        if (project == null) {
            return;
        }
        this.pathChooser.setFileSelectionMode(1);
        if (this.pathChooser.showDialog(this, I18n.getMessage("jsite.project.action.browse.choose")) == 0) {
            this.projectLocalPathTextField.setText(this.pathChooser.getSelectedFile().getPath());
        }
    }

    private void actionAdd() {
        String[] stringArray = null;
        if (!this.freenetInterface.hasNode()) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.project-files.no-node-selected"), null, 0);
            return;
        }
        try {
            stringArray = this.freenetInterface.generateKeyPair();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, MessageFormat.format(I18n.getMessage("jsite.project.keygen.io-error"), iOException.getMessage()), null, 0);
            return;
        }
        Project project = new Project();
        project.setName(I18n.getMessage("jsite.project.new-project.name"));
        project.setInsertURI(stringArray[0]);
        project.setRequestURI(stringArray[1]);
        project.setEdition(-1);
        project.setPath("");
        this.projectListModel.add(project);
        this.projectScrollPane.revalidate();
        this.projectScrollPane.repaint();
        this.projectList.setSelectedIndex(this.projectListModel.indexOf(project));
    }

    private void actionDelete() {
        int n = this.projectList.getSelectedIndex();
        if (n > -1 && JOptionPane.showConfirmDialog(this, MessageFormat.format(I18n.getMessage("jsite.project.action.delete-project.confirm"), ((Project)this.projectList.getSelectedValue()).getName()), null, 2, 2) == 0) {
            this.projectListModel.remove(n);
            this.projectList.clearSelection();
            if (this.projectListModel.getSize() != 0) {
                this.projectList.setSelectedIndex(Math.min(n, this.projectListModel.getSize() - 1));
            }
        }
    }

    private void actionClone() {
        int n = this.projectList.getSelectedIndex();
        if (n > -1) {
            Project project = new Project((Project)this.projectList.getSelectedValue());
            project.setName(MessageFormat.format(I18n.getMessage("jsite.project.action.clone-project.copy"), project.getName()));
            this.projectListModel.add(project);
            this.projectList.setSelectedIndex(this.projectListModel.indexOf(project));
        }
    }

    private void actionCopyURI() {
        int n = this.projectList.getSelectedIndex();
        if (n > -1) {
            Project project = (Project)this.projectList.getSelectedValue();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(project.getFinalRequestURI(0)), this);
            this.uriCopied = true;
        }
    }

    private void actionManageKeys() {
        int n = this.projectList.getSelectedIndex();
        if (n > -1) {
            Project project = (Project)this.projectList.getSelectedValue();
            KeyDialog keyDialog = new KeyDialog(this.freenetInterface, this.wizard);
            keyDialog.setPrivateKey(project.getInsertURI());
            keyDialog.setPublicKey(project.getRequestURI());
            keyDialog.setVisible(true);
            if (!keyDialog.wasCancelled()) {
                project.setInsertURI(keyDialog.getPrivateKey());
                project.setRequestURI(keyDialog.getPublicKey());
                this.updateCompleteURI();
            }
        }
    }

    private void actionResetEdition() {
        if (JOptionPane.showConfirmDialog(this, I18n.getMessage("jsite.project.warning.reset-edition"), null, 2) == 2) {
            return;
        }
        int n = this.projectList.getSelectedIndex();
        if (n > -1) {
            Project project = (Project)this.projectList.getSelectedValue();
            project.setEdition(-1);
            this.updateCompleteURI();
        }
    }

    private void updateCompleteURI() {
        int n = this.projectList.getSelectedIndex();
        if (n > -1) {
            Project project = (Project)this.projectList.getSelectedValue();
            this.projectCompleteUriTextField.setText(project.getFinalRequestURI(0));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.projectList.getSelectedIndex();
        Project project = (Project)this.projectList.getSelectedValue();
        this.projectNameTextField.setEnabled(n > -1);
        this.projectDescriptionTextField.setEnabled(n > -1);
        this.projectLocalPathTextField.setEnabled(n > -1);
        this.projectPathTextField.setEnabled(n > -1);
        this.projectLocalPathBrowseAction.setEnabled(n > -1);
        this.projectDeleteAction.setEnabled(n > -1);
        this.projectCloneAction.setEnabled(n > -1);
        this.projectCopyURIAction.setEnabled(n > -1);
        this.projectManageKeysAction.setEnabled(n > -1);
        this.projectResetEditionAction.setEnabled(n > -1);
        if (n > -1) {
            this.projectNameTextField.setText(project.getName());
            this.projectDescriptionTextField.setText(project.getDescription());
            this.projectLocalPathTextField.setText(project.getLocalPath());
            this.projectPathTextField.setText(project.getPath());
            this.projectCompleteUriTextField.setText("freenet:" + project.getFinalRequestURI(0));
        } else {
            this.projectNameTextField.setText("");
            this.projectDescriptionTextField.setText("");
            this.projectLocalPathTextField.setText("");
            this.projectPathTextField.setText("");
            this.projectCompleteUriTextField.setText("");
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTextField(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTextField(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.setTextField(documentEvent);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

