/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

public class Version
implements Comparable<Version> {
    private final int[] components;

    public Version(int ... nArray) {
        this.components = new int[nArray.length];
        System.arraycopy(nArray, 0, this.components, 0, nArray.length);
    }

    public int size() {
        return this.components.length;
    }

    public int getComponent(int n) {
        return this.components[n];
    }

    public static Version parse(String string) {
        String[] stringArray = string.split("\\.");
        int[] nArray = new int[stringArray.length];
        int n = -1;
        for (String string2 : stringArray) {
            try {
                nArray[++n] = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return new Version(nArray);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : this.components) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(n);
        }
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(Version version) {
        int n = Math.min(this.components.length, version.components.length);
        for (int i = 0; i < n; ++i) {
            if (version.components[i] == this.components[i]) continue;
            return this.components[i] - version.components[i];
        }
        return this.components.length - version.components.length;
    }
}

