/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.FileOption;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.gui.FileScanner;
import de.todesbaum.jsite.gui.FileScannerListener;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientPutComplexDir;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.DirectFileEntry;
import de.todesbaum.util.freenet.fcp2.FileEntry;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.RedirectFileEntry;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import de.todesbaum.util.io.Closer;
import de.todesbaum.util.io.ReplacingOutputStream;
import de.todesbaum.util.io.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ProjectInserter
implements FileScannerListener,
Runnable {
    private static final Logger logger = Logger.getLogger(ProjectInserter.class.getName());
    private static final int random = (int)(Math.random() * 2.147483647E9);
    private static int counter = 0;
    private List<InsertListener> insertListeners = new ArrayList<InsertListener>();
    protected Freenet7Interface freenetInterface;
    protected Project project;
    private FileScanner fileScanner;
    protected final Object lockObject = new Object();
    private String tempDirectory;
    private Connection connection;
    private volatile boolean cancelled = false;

    public void addInsertListener(InsertListener insertListener) {
        this.insertListeners.add(insertListener);
    }

    public void removeInsertListener(InsertListener insertListener) {
        this.insertListeners.remove(insertListener);
    }

    protected void fireProjectInsertStarted() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertStarted(this.project);
        }
    }

    protected void fireProjectURIGenerated(String string) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectURIGenerated(this.project, string);
        }
    }

    protected void fireProjectUploadFinished() {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectUploadFinished(this.project);
        }
    }

    protected void fireProjectInsertProgress(int n, int n2, int n3, int n4, boolean bl) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertProgress(this.project, n, n2, n3, n4, bl);
        }
    }

    protected void fireProjectInsertFinished(boolean bl, Throwable throwable) {
        for (InsertListener insertListener : this.insertListeners) {
            insertListener.projectInsertFinished(this.project, bl, throwable);
        }
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public void setFreenetInterface(Freenet7Interface freenet7Interface) {
        this.freenetInterface = freenet7Interface;
    }

    public void setTempDirectory(String string) {
        this.tempDirectory = string;
    }

    public void start() {
        this.cancelled = false;
        this.fileScanner = new FileScanner(this.project);
        this.fileScanner.addFileScannerListener(this);
        new Thread(this.fileScanner).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.cancelled = true;
        Object object = this.lockObject;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createFileInputStream(String string, FileOption fileOption, int n, long[] lArray) throws IOException {
        File file = new File(this.project.getLocalPath(), string);
        lArray[0] = file.length();
        if (!fileOption.getReplaceEdition()) {
            return new FileInputStream(file);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.min(Integer.MAX_VALUE, (int)lArray[0]));
        ReplacingOutputStream replacingOutputStream = new ReplacingOutputStream(byteArrayOutputStream);
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            replacingOutputStream.addReplacement("$[EDITION]", String.valueOf(n));
            replacingOutputStream.addReplacement("$[URI]", this.project.getFinalRequestURI(0));
            for (int i = 1; i <= fileOption.getEditionRange(); ++i) {
                replacingOutputStream.addReplacement("$[URI+" + i + "]", this.project.getFinalRequestURI(i));
                replacingOutputStream.addReplacement("$[EDITION+" + i + "]", String.valueOf(n + i));
            }
            StreamCopier.copy(fileInputStream, replacingOutputStream, lArray[0]);
        }
        finally {
            Closer.close(fileInputStream);
            Closer.close(replacingOutputStream);
            Closer.close(byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        lArray[0] = byArray.length;
        return new ByteArrayInputStream(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream createContainerInputStream(Map<String, List<String>> map, String string, int n, long[] lArray) throws IOException {
        File file = File.createTempFile("jsite", ".zip", this.tempDirectory == null ? null : new File(this.tempDirectory));
        file.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            for (String string2 : map.get(string)) {
                File file2 = new File(this.project.getLocalPath(), string2);
                if (!file2.exists()) continue;
                ZipEntry zipEntry = new ZipEntry(string2);
                long[] lArray2 = new long[1];
                InputStream inputStream = this.createFileInputStream(string2, this.project.getFileOption(string2), n, lArray2);
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    StreamCopier.copy(inputStream, zipOutputStream, lArray2[0]);
                }
                finally {
                    zipOutputStream.closeEntry();
                    inputStream.close();
                }
            }
        }
        finally {
            zipOutputStream.closeEntry();
            Closer.close(zipOutputStream);
            Closer.close(fileOutputStream);
        }
        lArray[0] = file.length();
        return new FileInputStream(file);
    }

    private FileEntry createFileEntry(String string, int n, Map<String, List<String>> map) {
        FileEntry fileEntry = null;
        FileOption fileOption = this.project.getFileOption(string);
        if (string.startsWith("/container/:")) {
            String string2 = string.substring("/container/:".length());
            try {
                long[] lArray = new long[1];
                InputStream inputStream = this.createContainerInputStream(map, string2, n, lArray);
                fileEntry = new DirectFileEntry(string2 + ".zip", "application/zip", inputStream, lArray[0]);
            }
            catch (IOException iOException) {}
        } else if (fileOption.isInsert()) {
            try {
                long[] lArray = new long[1];
                InputStream inputStream = this.createFileInputStream(string, fileOption, n, lArray);
                fileEntry = new DirectFileEntry(string, this.project.getFileOption(string).getMimeType(), inputStream, lArray[0]);
            }
            catch (IOException iOException) {}
        } else if (fileOption.isInsertRedirect()) {
            fileEntry = new RedirectFileEntry(string, fileOption.getMimeType(), fileOption.getCustomKey());
        }
        return fileEntry;
    }

    private void createContainers(List<String> list, List<String> list2, Map<String, List<String>> map) {
        for (String string : new ArrayList<String>(list)) {
            FileOption fileOption = this.project.getFileOption(string);
            String string2 = fileOption.getContainer();
            if (string2.equals("")) continue;
            if (!list2.contains(string2)) {
                list2.add(string2);
                map.put(string2, new ArrayList());
                list.add("/container/:" + string2);
            }
            map.get(string2).add(string);
            list.remove(string);
        }
    }

    public static CheckReport validateProject(Project project) {
        FileOption fileOption;
        boolean bl;
        Object object;
        CheckReport checkReport = new CheckReport();
        if (project.getLocalPath() == null || project.getLocalPath().trim().length() == 0) {
            checkReport.addIssue("error.no-local-path", true, new String[0]);
        }
        if (project.getPath() == null || project.getPath().trim().length() == 0) {
            checkReport.addIssue("error.no-path", true, new String[0]);
        }
        if (project.getIndexFile() == null || project.getIndexFile().length() == 0) {
            checkReport.addIssue("warning.empty-index", false, new String[0]);
        } else {
            object = new File(project.getLocalPath(), project.getIndexFile());
            if (!((File)object).exists()) {
                checkReport.addIssue("error.index-missing", true, new String[0]);
            }
        }
        object = project.getIndexFile();
        boolean bl2 = bl = object != null;
        if (bl && !project.getFileOption((String)object).getContainer().equals("")) {
            checkReport.addIssue("warning.container-index", false, new String[0]);
        }
        List<String> list = Arrays.asList("text/html", "application/xhtml+xml");
        if (bl && !list.contains(project.getFileOption((String)object).getMimeType())) {
            checkReport.addIssue("warning.index-not-html", false, new String[0]);
        }
        Map<String, FileOption> map = project.getFileOptions();
        Set<Map.Entry<String, FileOption>> set = map.entrySet();
        boolean bl3 = false;
        for (Map.Entry<String, FileOption> object2 : set) {
            String string = object2.getKey();
            fileOption = object2.getValue();
            bl3 |= fileOption.isInsert() || fileOption.isInsertRedirect();
            if (string.equals(project.getIndexFile()) && !fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                checkReport.addIssue("error.index-not-inserted", true, new String[0]);
            }
            if (fileOption.isInsert() || !fileOption.isInsertRedirect() || fileOption.getCustomKey().length() != 0 && !"CHK@".equals(fileOption.getCustomKey())) continue;
            checkReport.addIssue("error.no-custom-key", true, string);
        }
        if (!bl3) {
            checkReport.addIssue("error.no-files-to-insert", true, new String[0]);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry<String, FileOption> entry : set) {
            fileOption = entry.getValue();
            if (!fileOption.isInsert() && !fileOption.isInsertRedirect()) {
                logger.log(Level.FINEST, "Ignoring {0}.", entry.getKey());
                continue;
            }
            String string = entry.getKey();
            if (fileOption.hasChangedName()) {
                string = fileOption.getChangedName();
            }
            logger.log(Level.FINEST, "Adding \u201a\u00c4\u00fa{0}\u201a\u00c4\u00f9 for {1}.", new Object[]{string, entry.getKey()});
            if (hashSet.add(string)) continue;
            checkReport.addIssue("error.duplicate-file", true, string);
        }
        return checkReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        this.fireProjectInsertStarted();
        List<String> list = this.fileScanner.getFiles();
        Object object2 = this.lockObject;
        synchronized (object2) {
            this.connection = this.freenetInterface.getConnection("project-insert-" + random + counter++);
        }
        this.connection.setTempDirectory(this.tempDirectory);
        boolean bl = false;
        IOException iOException = null;
        try {
            bl = this.connection.connect();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (!bl || this.cancelled) {
            this.fireProjectInsertFinished(false, this.cancelled ? new AbortedException() : iOException);
            return;
        }
        Client client = new Client(this.connection);
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        this.createContainers(list, arrayList, hashMap);
        int n = this.project.getEdition();
        String string = "USK@" + this.project.getInsertURI() + "/" + this.project.getPath() + "/" + n + "/";
        ClientPutComplexDir clientPutComplexDir = new ClientPutComplexDir("dir-" + counter++, string, this.tempDirectory);
        if (this.project.getIndexFile() != null && this.project.getIndexFile().length() > 0) {
            clientPutComplexDir.setDefaultName(this.project.getIndexFile());
        }
        clientPutComplexDir.setVerbosity(Verbosity.ALL);
        clientPutComplexDir.setMaxRetries(-1);
        clientPutComplexDir.setEarlyEncode(false);
        for (String string2 : list) {
            FileEntry fileEntry = this.createFileEntry(string2, n, hashMap);
            if (fileEntry == null) continue;
            try {
                clientPutComplexDir.addFileEntry(fileEntry);
            }
            catch (IOException iOException3) {
                this.fireProjectInsertFinished(false, iOException3);
                return;
            }
        }
        try {
            client.execute(clientPutComplexDir);
        }
        catch (IOException iOException4) {
            this.fireProjectInsertFinished(false, iOException4);
            return;
        }
        Object object3 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (!bl4 && !this.cancelled) {
            object = client.readMessage();
            boolean bl6 = bl4 = object == null || (bl5 = client.isDisconnected());
            if (bl2) {
                this.fireProjectUploadFinished();
                bl2 = false;
            }
            logger.log(Level.FINE, "Received message: " + object);
            if (bl4) continue;
            String string3 = ((Message)object).getName();
            if ("URIGenerated".equals(string3)) {
                object3 = ((Message)object).get("URI");
                this.fireProjectURIGenerated((String)object3);
            }
            if ("SimpleProgress".equals(string3)) {
                int n2 = Integer.parseInt(((Message)object).get("Total"));
                int n3 = Integer.parseInt(((Message)object).get("Succeeded"));
                int n4 = Integer.parseInt(((Message)object).get("FatallyFailed"));
                int n5 = Integer.parseInt(((Message)object).get("Failed"));
                boolean bl7 = Boolean.parseBoolean(((Message)object).get("FinalizedTotal"));
                this.fireProjectInsertProgress(n3, n5, n4, n2, bl7);
            }
            bl4 = (bl3 = "PutSuccessful".equals(string3)) || "PutFailed".equals(string3) || string3.endsWith("Error");
        }
        if (bl3) {
            object = ((String)object3).substring(((String)object3).lastIndexOf(47) + 1);
            int n6 = Integer.parseInt((String)object);
            this.project.setEdition(n6);
            this.project.setLastInsertionTime(System.currentTimeMillis());
        }
        this.fireProjectInsertFinished(bl3, this.cancelled ? new AbortedException() : (bl5 ? new IOException("Connection terminated") : null));
    }

    @Override
    public void fileScannerFinished(FileScanner fileScanner) {
        if (!fileScanner.isError()) {
            new Thread(this).start();
        } else {
            this.fireProjectInsertFinished(false, null);
        }
        fileScanner.removeFileScannerListener(this);
    }

    public static class Issue {
        private final String errorKey;
        private final boolean fatal;
        private String[] parameters;

        protected Issue(String string, boolean bl, String ... stringArray) {
            this.errorKey = string;
            this.fatal = bl;
            this.parameters = stringArray;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public boolean isFatal() {
            return this.fatal;
        }

        public String[] getParameters() {
            return this.parameters;
        }
    }

    public static class CheckReport
    implements Iterable<Issue> {
        private final List<Issue> issues = new ArrayList<Issue>();

        public void addIssue(Issue issue) {
            this.issues.add(issue);
        }

        public void addIssue(String string, boolean bl, String ... stringArray) {
            this.addIssue(new Issue(string, bl, stringArray));
        }

        @Override
        public Iterator<Issue> iterator() {
            return this.issues.iterator();
        }

        public boolean isEmpty() {
            return this.issues.isEmpty();
        }

        public int size() {
            return this.issues.size();
        }
    }
}

