/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.gui;

import de.todesbaum.jsite.application.AbortedException;
import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.i18n.I18n;
import de.todesbaum.jsite.i18n.I18nContainer;
import de.todesbaum.util.swing.TWizard;
import de.todesbaum.util.swing.TWizardPage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ProjectInsertPage
extends TWizardPage
implements InsertListener,
ClipboardOwner {
    private static final Logger logger = Logger.getLogger(ProjectInsertPage.class.getName());
    private ProjectInserter projectInserter;
    private Action copyURIAction;
    private JTextField requestURITextField;
    private JLabel startTimeLabel;
    private JProgressBar progressBar;
    private long startTime = 0L;
    private volatile int insertedBlocks;
    private boolean uriCopied;
    private volatile boolean running = false;

    public ProjectInsertPage(TWizard tWizard) {
        super(tWizard);
        this.createActions();
        this.pageInit();
        this.setHeading(I18n.getMessage("jsite.insert.heading"));
        this.setDescription(I18n.getMessage("jsite.insert.description"));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.setHeading(I18n.getMessage("jsite.insert.heading"));
                ProjectInsertPage.this.setDescription(I18n.getMessage("jsite.insert.description"));
            }
        });
        this.projectInserter = new ProjectInserter();
        this.projectInserter.addInsertListener(this);
    }

    private void createActions() {
        this.copyURIAction = new AbstractAction(I18n.getMessage("jsite.project.action.copy-uri")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectInsertPage.this.actionCopyURI();
            }
        };
        this.copyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
        this.copyURIAction.putValue("MnemonicKey", 85);
        this.copyURIAction.setEnabled(false);
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.copyURIAction.putValue("Name", I18n.getMessage("jsite.project.action.copy-uri"));
                ProjectInsertPage.this.copyURIAction.putValue("ShortDescription", I18n.getMessage("jsite.project.action.copy-uri.tooltip"));
            }
        });
    }

    private void pageInit() {
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.createProjectInsertPanel(), "Center");
    }

    private JComponent createProjectInsertPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.requestURITextField = new JTextField();
        this.requestURITextField.setEditable(false);
        this.startTimeLabel = new JLabel();
        this.progressBar = new JProgressBar(0, 1);
        this.progressBar.setStringPainted(true);
        this.progressBar.setValue(0);
        final JLabel jLabel = new JLabel("<html><b>" + I18n.getMessage("jsite.insert.project-information") + "</b></html>");
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        final JLabel jLabel2 = new JLabel(I18n.getMessage("jsite.insert.request-uri") + ":");
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel.add((Component)this.requestURITextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final JLabel jLabel3 = new JLabel(I18n.getMessage("jsite.insert.start-time") + ":");
        jPanel.add((Component)jLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel.add((Component)this.startTimeLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        final JLabel jLabel4 = new JLabel(I18n.getMessage("jsite.insert.progress") + ":");
        jPanel.add((Component)jLabel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(6, 18, 0, 0), 0, 0));
        jPanel.add((Component)this.progressBar, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(6, 6, 0, 0), 0, 0));
        jPanel.add((Component)new JButton(this.copyURIAction), new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 22, 0, new Insets(12, 18, 0, 0), 0, 0));
        I18nContainer.getInstance().registerRunnable(new Runnable(){

            @Override
            public void run() {
                jLabel.setText("<html><b>" + I18n.getMessage("jsite.insert.project-information") + "</b></html>");
                jLabel2.setText(I18n.getMessage("jsite.insert.request-uri") + ":");
                jLabel3.setText(I18n.getMessage("jsite.insert.start-time") + ":");
                if (ProjectInsertPage.this.startTime != 0L) {
                    ProjectInsertPage.this.startTimeLabel.setText(DateFormat.getDateTimeInstance().format(new Date(ProjectInsertPage.this.startTime)));
                } else {
                    ProjectInsertPage.this.startTimeLabel.setText("");
                }
                jLabel4.setText(I18n.getMessage("jsite.insert.progress") + ":");
            }
        });
        return jPanel;
    }

    @Override
    public void pageAdded(TWizard tWizard) {
        this.wizard.setPreviousName(I18n.getMessage("jsite.wizard.previous"));
        this.wizard.setPreviousEnabled(false);
        this.wizard.setNextName(I18n.getMessage("jsite.general.cancel"));
        this.wizard.setQuitName(I18n.getMessage("jsite.wizard.quit"));
    }

    public void startInsert() {
        this.running = true;
        this.copyURIAction.setEnabled(false);
        this.progressBar.setValue(0);
        this.progressBar.setString(I18n.getMessage("jsite.insert.starting"));
        this.progressBar.setFont(this.progressBar.getFont().deriveFont(0));
        this.projectInserter.start();
    }

    public void stopInsert() {
        if (this.running) {
            this.wizard.setNextEnabled(false);
            this.projectInserter.stop();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setProject(final Project project) {
        this.projectInserter.setProject(project);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.requestURITextField.setText(project.getFinalRequestURI(1));
            }
        });
    }

    public void setFreenetInterface(Freenet7Interface freenet7Interface) {
        this.projectInserter.setFreenetInterface(freenet7Interface);
    }

    public void setTempDirectory(String string) {
        this.projectInserter.setTempDirectory(string);
    }

    public boolean wasUriCopied() {
        return this.uriCopied;
    }

    @Override
    public void projectInsertStarted(Project project) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.startTimeLabel.setText(DateFormat.getDateTimeInstance().format(new Date()));
            }
        });
    }

    @Override
    public void projectUploadFinished(Project project) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void projectURIGenerated(Project project, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.copyURIAction.setEnabled(true);
                ProjectInsertPage.this.requestURITextField.setText(string);
            }
        });
        logger.log(Level.FINEST, "Insert generated URI: " + string);
        int n = string.indexOf(47);
        n = string.indexOf(47, n + 1);
        int n2 = string.indexOf(47, n + 1);
        if (n2 == -1) {
            n2 = string.length();
        }
        String string2 = string.substring(n + 1, n2);
        logger.log(Level.FINEST, "Extracted edition number: " + string2);
        int n3 = -1;
        try {
            n3 = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        logger.log(Level.FINEST, "Insert edition: " + n3 + ", Project edition: " + project.getEdition());
        if (n3 != -1 && n3 == project.getEdition()) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.reinserted-edition"), I18n.getMessage("jsite.insert.reinserted-edition.title"), 1);
        }
    }

    @Override
    public void projectInsertProgress(Project project, final int n, final int n2, final int n3, final int n4, final boolean bl) {
        this.insertedBlocks = n;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.progressBar.setMaximum(n4);
                ProjectInsertPage.this.progressBar.setValue(n + n2 + n3);
                int n5 = (n + n2 + n3) * 100 / n4;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(n5).append("% (");
                stringBuilder.append(n + n2 + n3).append('/').append(n4);
                stringBuilder.append(") (");
                stringBuilder.append(ProjectInsertPage.this.getTransferRate());
                stringBuilder.append(' ').append(I18n.getMessage("jsite.insert.k-per-s")).append(')');
                ProjectInsertPage.this.progressBar.setString(stringBuilder.toString());
                if (bl) {
                    ProjectInsertPage.this.progressBar.setFont(ProjectInsertPage.this.progressBar.getFont().deriveFont(1));
                }
            }
        });
    }

    @Override
    public void projectInsertFinished(Project project, boolean bl, Throwable throwable) {
        this.running = false;
        if (bl) {
            String string = I18n.getMessage("jsite.insert.okay-copy-uri");
            int n = JOptionPane.showOptionDialog(this, I18n.getMessage("jsite.insert.inserted"), I18n.getMessage("jsite.insert.done.title"), 0, 1, null, new Object[]{I18n.getMessage("jsite.general.ok"), string}, string);
            if (n == 1) {
                this.actionCopyURI();
            }
        } else if (throwable == null) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.insert-failed"), I18n.getMessage("jsite.insert.insert-failed.title"), 0);
        } else if (throwable instanceof AbortedException) {
            JOptionPane.showMessageDialog(this, I18n.getMessage("jsite.insert.insert-aborted"), I18n.getMessage("jsite.insert.insert-aborted.title"), 1);
        } else {
            JOptionPane.showMessageDialog(this, MessageFormat.format(I18n.getMessage("jsite.insert.insert-failed-with-cause"), throwable.getMessage()), I18n.getMessage("jsite.insert.insert-failed.title"), 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInsertPage.this.progressBar.setValue(ProjectInsertPage.this.progressBar.getMaximum());
                ProjectInsertPage.this.progressBar.setString(I18n.getMessage("jsite.insert.done") + " (" + ProjectInsertPage.this.getTransferRate() + " " + I18n.getMessage("jsite.insert.k-per-s") + ")");
                ProjectInsertPage.this.wizard.setNextName(I18n.getMessage("jsite.wizard.next"));
                ProjectInsertPage.this.wizard.setNextEnabled(true);
                ProjectInsertPage.this.wizard.setQuitEnabled(true);
            }
        });
    }

    private void actionCopyURI() {
        this.uriCopied = true;
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new StringSelection(this.requestURITextField.getText()), this);
    }

    private String formatNumber(double d, int n) {
        int n2 = (int)Math.pow(10.0, n);
        String string = String.valueOf((double)((int)(d * (double)n2)) / (double)n2);
        if (string.indexOf(46) == -1) {
            string = string + '.';
            for (int i = 0; i < n; ++i) {
                string = string + "0";
            }
        }
        return string;
    }

    private String getTransferRate() {
        return this.formatNumber((double)this.insertedBlocks * 32.0 / (double)((System.currentTimeMillis() - this.startTime) / 1000L), 1);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

