/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.application;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.UpdateListener;
import de.todesbaum.jsite.main.Main;
import de.todesbaum.jsite.main.Version;
import de.todesbaum.util.freenet.fcp2.Client;
import de.todesbaum.util.freenet.fcp2.ClientGet;
import de.todesbaum.util.freenet.fcp2.Connection;
import de.todesbaum.util.freenet.fcp2.Message;
import de.todesbaum.util.freenet.fcp2.Persistence;
import de.todesbaum.util.freenet.fcp2.ReturnType;
import de.todesbaum.util.freenet.fcp2.Verbosity;
import de.todesbaum.util.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateChecker
implements Runnable {
    private static final Logger logger = Logger.getLogger(UpdateChecker.class.getName());
    private static int counter = 0;
    private static final int UPDATE_EDITION = 0;
    private static final String UPDATE_KEY = "USK@e3myoFyp5avg6WYN16ImHri6J7Nj8980Fm~aQe4EX1U,QvbWT0ImE0TwLODTl7EoJx2NBnwDxTbLTE6zkB-eGPs,AQACAAE";
    private final Object syncObject = new Object();
    private final List<UpdateListener> updateListeners = new ArrayList<UpdateListener>();
    private boolean shouldStop = false;
    private int lastUpdateEdition = 0;
    private Version lastVersion = Main.getVersion();
    private final Freenet7Interface freenetInterface;

    public UpdateChecker(Freenet7Interface freenet7Interface) {
        this.freenetInterface = freenet7Interface;
    }

    public void addUpdateListener(UpdateListener updateListener) {
        this.updateListeners.add(updateListener);
    }

    public void removeUpdateListener(UpdateListener updateListener) {
        this.updateListeners.remove(updateListener);
    }

    protected void fireUpdateFound(Version version, long l) {
        for (UpdateListener updateListener : this.updateListeners) {
            updateListener.foundUpdateData(version, l);
        }
    }

    public Version getLatestVersion() {
        return this.lastVersion;
    }

    public void start() {
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.syncObject;
        synchronized (object) {
            this.shouldStop = true;
            this.syncObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldStop() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.shouldStop;
        }
    }

    private String constructUpdateKey(int n) {
        return "USK@e3myoFyp5avg6WYN16ImHri6J7Nj8980Fm~aQe4EX1U,QvbWT0ImE0TwLODTl7EoJx2NBnwDxTbLTE6zkB-eGPs,AQACAAE/jSite/" + n + "/jSite.properties";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Connection connection = this.freenetInterface.getConnection("jSite-" + ++counter + "-UpdateChecker");
        try {
            connection.connect();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Client client = new Client(connection);
        boolean bl = false;
        int n = this.lastUpdateEdition;
        while (!this.shouldStop()) {
            bl = false;
            logger.log(Level.FINE, "Trying " + this.constructUpdateKey(n));
            ClientGet clientGet = new ClientGet("get-update-key");
            clientGet.setUri(this.constructUpdateKey(n));
            clientGet.setPersistence(Persistence.CONNECTION);
            clientGet.setReturnType(ReturnType.direct);
            clientGet.setVerbosity(Verbosity.ALL);
            try {
                client.execute(clientGet);
                boolean bl2 = false;
                while (!bl2) {
                    Version version;
                    Object object;
                    Message message = client.readMessage();
                    logger.log(Level.FINEST, "Received message: " + message);
                    if ("GetFailed".equals(message.getName()) && "27".equals(message.get("code"))) {
                        object = message.get("redirecturi").split("/")[2];
                        int n2 = -1;
                        try {
                            n2 = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n2 != -1) {
                            logger.log(Level.INFO, "Found new edition " + n2);
                            n = n2;
                            this.lastUpdateEdition = n2;
                            bl = true;
                            break;
                        }
                    }
                    if (!"AllData".equals(message.getName())) continue;
                    logger.log(Level.FINE, "Update data found.");
                    object = null;
                    Properties properties = new Properties();
                    try {
                        object = message.getPayloadInputStream();
                        properties.load((InputStream)object);
                    }
                    finally {
                        Closer.close((InputStream)object);
                    }
                    String string = properties.getProperty("jSite.Version");
                    if (string == null || (version = Version.parse(string)) == null) continue;
                    this.lastVersion = version;
                    String string2 = properties.getProperty("jSite.Date");
                    logger.log(Level.FINEST, "Version timestamp: " + string2);
                    long l = -1L;
                    try {
                        l = Long.parseLong(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.fireUpdateFound(version, l);
                    bl2 = true;
                    bl = true;
                    ++n;
                }
            }
            catch (IOException iOException) {
                logger.log(Level.INFO, "Got IOException: " + iOException.getMessage());
                iOException.printStackTrace();
            }
            if (bl || this.shouldStop()) continue;
            Object object = this.syncObject;
            synchronized (object) {
                try {
                    this.syncObject.wait(900000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

