/*
 * Decompiled with CFR 0.152.
 */
package de.todesbaum.jsite.main;

import de.todesbaum.jsite.application.Freenet7Interface;
import de.todesbaum.jsite.application.InsertListener;
import de.todesbaum.jsite.application.Node;
import de.todesbaum.jsite.application.Project;
import de.todesbaum.jsite.application.ProjectInserter;
import de.todesbaum.jsite.main.Configuration;
import java.io.PrintWriter;

public class CLI
implements InsertListener {
    private Object lockObject = new Object();
    private PrintWriter outputWriter = new PrintWriter(System.out, true);
    private Freenet7Interface freenetInterface;
    private ProjectInserter projectInserter = new ProjectInserter();
    private Node[] nodes;
    private Project[] projects;
    private boolean finished = false;
    private boolean success;

    private CLI(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("-h") || stringArray[0].equals("--help")) {
            this.outputWriter.println("\nParameters:\n");
            this.outputWriter.println("  --node=<node name>");
            this.outputWriter.println("  --project=<project name>");
            this.outputWriter.println("  --local-directory=<local directory>");
            this.outputWriter.println("  --path=<path>");
            this.outputWriter.println("  --edition=<edition>");
            this.outputWriter.println("\nA project gets inserted when a new project is loaded on the command line,");
            this.outputWriter.println("or when the command line is finished. --local-directory, --path, and --edition");
            this.outputWriter.println("override the parameters in the project.");
            return;
        }
        Configuration configuration = new Configuration();
        if (!configuration.createLockFile()) {
            this.outputWriter.println("Lock file found!");
            return;
        }
        this.projectInserter.addInsertListener(this);
        this.projects = configuration.getProjects();
        Node node = configuration.getSelectedNode();
        this.nodes = configuration.getNodes();
        this.freenetInterface = new Freenet7Interface();
        this.freenetInterface.setNode(node);
        this.projectInserter.setFreenetInterface(this.freenetInterface);
        Project project = null;
        for (String string : stringArray) {
            String string2 = string.substring(string.indexOf(61) + 1).trim();
            if (string.startsWith("--node=")) {
                Node node2 = this.getNode(string2);
                if (node2 == null) {
                    this.outputWriter.println("Node \"" + string2 + "\" not found.");
                    return;
                }
                node = node2;
                this.freenetInterface.setNode(node);
                continue;
            }
            if (string.startsWith("--project=")) {
                if (project != null) {
                    if (this.insertProject(project)) {
                        this.outputWriter.println("Project \"" + project.getName() + "\" successfully inserted.");
                    } else {
                        this.outputWriter.println("Project \"" + project.getName() + "\" was not successfully inserted.");
                    }
                    project = null;
                }
                if ((project = this.getProject(string2)) != null) continue;
                this.outputWriter.println("Project \"" + string2 + "\" not found.");
                continue;
            }
            if (string.startsWith("--local-directory")) {
                if (project == null) {
                    this.outputWriter.println("You can't specifiy --local-directory before --project.");
                    return;
                }
                project.setLocalPath(string2);
                continue;
            }
            if (string.startsWith("--path=")) {
                if (project == null) {
                    this.outputWriter.println("You can't specify --path before --project.");
                    return;
                }
                project.setPath(string2);
                continue;
            }
            if (string.startsWith("--edition=")) {
                if (project == null) {
                    this.outputWriter.println("You can't specify --edition before --project.");
                    return;
                }
                project.setEdition(Integer.parseInt(string2));
                continue;
            }
            this.outputWriter.println("Unknown parameter: " + string);
            return;
        }
        if (project != null) {
            if (this.insertProject(project)) {
                this.outputWriter.println("Project \"" + project.getName() + "\" successfully inserted.");
            } else {
                this.outputWriter.println("Project \"" + project.getName() + "\" was not successfully inserted.");
            }
        }
        configuration.setProjects(this.projects);
        configuration.save();
    }

    private Project getProject(String string) {
        for (Project project : this.projects) {
            if (!project.getName().equals(string)) continue;
            return project;
        }
        return null;
    }

    private Node getNode(String string) {
        for (Node node : this.nodes) {
            if (!node.getName().equals(string)) continue;
            return node;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertProject(Project project) {
        if (!this.freenetInterface.hasNode()) {
            this.outputWriter.println("Node is not running!");
            return false;
        }
        this.projectInserter.setProject(project);
        this.projectInserter.start();
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.finished) {
                try {
                    this.lockObject.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.success;
    }

    @Override
    public void projectInsertStarted(Project project) {
        this.outputWriter.println("Starting Insert of project \"" + project.getName() + "\".");
    }

    @Override
    public void projectUploadFinished(Project project) {
        this.outputWriter.println("Project \"" + project.getName() + "\" has ben uploaded, starting insert...");
    }

    @Override
    public void projectURIGenerated(Project project, String string) {
        this.outputWriter.println("URI: " + string);
    }

    @Override
    public void projectInsertProgress(Project project, int n, int n2, int n3, int n4, boolean bl) {
        this.outputWriter.println("Progress: " + n + " done, " + n2 + " failed, " + n3 + " fatal, " + n4 + " total" + (bl ? " (finalized)" : "") + ", " + (n + n2 + n3) * 100 / n4 + "%");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void projectInsertFinished(Project project, boolean bl, Throwable throwable) {
        this.outputWriter.println("Request URI: " + project.getFinalRequestURI(0));
        this.finished = true;
        this.success = bl;
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notify();
        }
    }

    public static void main(String[] stringArray) {
        new CLI(stringArray);
    }
}

